/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.savage_and_ravage.common.entity.monster;

import com.teamabnormals.savage_and_ravage.common.entity.OwnableMob;
import com.teamabnormals.savage_and_ravage.common.entity.ai.goal.CreepieSwellGoal;
import com.teamabnormals.savage_and_ravage.common.entity.ai.goal.FollowMobOwnerGoal;
import com.teamabnormals.savage_and_ravage.common.entity.ai.goal.MobOwnerHurtByTargetGoal;
import com.teamabnormals.savage_and_ravage.common.entity.ai.goal.MobOwnerHurtTargetGoal;
import com.teamabnormals.savage_and_ravage.core.SRConfig;
import com.teamabnormals.savage_and_ravage.core.registry.SRParticleTypes;
import com.teamabnormals.savage_and_ravage.core.registry.SRSounds;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.scores.Team;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

@OnlyIn(value=Dist.CLIENT, _interface=PowerableMob.class)
public class Creepie
extends Monster
implements PowerableMob,
OwnableMob {
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(Creepie.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> POWERED = SynchedEntityData.m_135353_(Creepie.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IGNITED = SynchedEntityData.m_135353_(Creepie.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(Creepie.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> CONVERSION_TIME = SynchedEntityData.m_135353_(Creepie.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public boolean attackPlayersOnly;
    public int lastActiveTime;
    public int timeSinceIgnited;
    public int fuseTime = 30;
    private int growingAge = -24000;
    private int forcedAgeTimer;
    private float explosionRadius = 1.2f;
    private boolean hasStartedConverting = false;

    public Creepie(EntityType<? extends Creepie> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 0;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new CreepieSwellGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(3, (Goal)new FollowMobOwnerGoal((Mob)this, 1.0, 2.0f, 20.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new MobOwnerHurtByTargetGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new MobOwnerHurtTargetGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, target -> this.getOwnerId() == null && !(target instanceof Creepie) && !(target instanceof Creeper) && !this.attackPlayersOnly));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 5, false, false, target -> this.getOwnerId() == null));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, 0.35);
    }

    public int m_6056_() {
        return this.m_5448_() == null ? 3 : 3 + (int)(this.m_21223_() - 1.0f);
    }

    protected boolean m_8028_() {
        return this.getOwner() == null;
    }

    public boolean m_6935_(Player playerIn) {
        return this.getOwner() == null;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        boolean flag = super.m_142535_(distance, damageMultiplier, source);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
        return flag;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STATE, (Object)-1);
        this.f_19804_.m_135372_(POWERED, (Object)false);
        this.f_19804_.m_135372_(IGNITED, (Object)false);
        this.f_19804_.m_135372_(CONVERSION_TIME, (Object)-1);
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getOwnerId() != null) {
            compound.m_128362_("OwnerUUID", this.getOwnerId());
        }
        compound.m_128405_("Age", this.getGrowingAge());
        compound.m_128405_("ConversionTime", this.getConversionTime());
        compound.m_128376_("Fuse", (short)this.fuseTime);
        compound.m_128350_("ExplosionRadius", this.explosionRadius);
        compound.m_128379_("Ignited", this.hasIgnited());
        if (((Boolean)this.f_19804_.m_135370_(POWERED)).booleanValue()) {
            compound.m_128379_("Powered", true);
        }
        compound.m_128379_("AttackPlayersOnly", this.attackPlayersOnly);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Fuse", 99)) {
            this.fuseTime = compound.m_128448_("Fuse");
        }
        if (compound.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = compound.m_128457_("ExplosionRadius");
        }
        if (compound.m_128425_("Age", 99)) {
            this.setGrowingAge(compound.m_128451_("Age"));
        }
        if (compound.m_128471_("Ignited")) {
            this.ignite();
        }
        this.f_19804_.m_135381_(POWERED, (Object)compound.m_128471_("Powered"));
        if (compound.m_128425_("ConversionTime", 99) && compound.m_128451_("ConversionTime") > -1) {
            this.startConversion(compound.m_128451_("ConversionTime"));
        }
        if (compound.m_128403_("OwnerUUID")) {
            this.setOwnerId(compound.m_128342_("OwnerUUID"));
        }
        this.attackPlayersOnly = compound.m_128471_("AttackPlayersOnly");
    }

    public boolean m_7090_() {
        return (Boolean)this.f_19804_.m_135370_(POWERED);
    }

    public void setCharged(boolean charged) {
        this.f_19804_.m_135381_(POWERED, (Object)charged);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)Items.f_42555_);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.8f;
    }

    public int getGrowingAge() {
        return this.growingAge;
    }

    private void ageUp(int growthSeconds) {
        int i = this.getGrowingAge();
        if ((i += growthSeconds * 20) > 0) {
            i = 0;
        }
        this.setGrowingAge(i);
        if (this.forcedAgeTimer == 0) {
            this.forcedAgeTimer = 40;
        }
    }

    public void setGrowingAge(int age) {
        int i = this.growingAge;
        this.growingAge = age;
        if (i < 0 && age >= 0) {
            this.startConversion(this.f_19796_.m_188503_(80) + 160);
        }
    }

    protected void explode() {
        if (!this.f_19853_.m_5776_()) {
            Explosion.BlockInteraction mode = (Boolean)SRConfig.COMMON.creepieExplosionsDestroyBlocks.get() != false && ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
            float chargedModifier = this.m_7090_() ? 2.0f : 1.0f;
            this.f_20890_ = true;
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explosionRadius * chargedModifier, mode);
            this.m_146870_();
            this.spawnLingeringCloud();
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.m_5776_() && this.forcedAgeTimer > 0) {
            if (this.forcedAgeTimer % 4 == 0) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0.0, 0.0, 0.0);
            }
            --this.forcedAgeTimer;
        }
        if (this.m_6084_()) {
            int i = this.getGrowingAge();
            if (i < 0) {
                this.setGrowingAge(++i);
            } else if (i > 0) {
                this.setGrowingAge(--i);
            }
        }
    }

    public float m_6100_() {
        return (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.5f;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)SRSounds.ENTITY_CREEPIE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SRSounds.ENTITY_CREEPIE_DEATH.get();
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.m_5496_((SoundEvent)SRSounds.ENTITY_CREEPIE_PRIMED.get(), this.m_6121_(), this.m_6100_());
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
            if (this.isConverting()) {
                if (this.hasStartedConverting) {
                    this.m_5496_((SoundEvent)SRSounds.ENTITY_CREEPIE_CONVERT.get(), 1.0f, 1.0f);
                    this.hasStartedConverting = false;
                }
                this.setConversionTime(this.getConversionTime() - 1);
                if (this.getConversionTime() <= 0) {
                    this.finishConversion(this.f_19853_);
                }
                if (this.f_19853_.m_5776_()) {
                    this.f_19853_.m_7106_((ParticleOptions)SRParticleTypes.CREEPER_SPORES.get(), this.m_20185_() - 0.5 + (double)this.f_19796_.m_188501_(), this.m_20186_() + 0.5, this.m_20189_() - 0.5 + (double)this.f_19796_.m_188501_(), 0.0, (double)(this.f_19796_.m_188501_() / 5.0f), 0.0);
                }
            }
        }
        super.m_8119_();
    }

    public boolean m_7327_(Entity entityIn) {
        return true;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == Items.f_42499_ && this.getGrowingAge() < 0) {
            this.consumeItemFromStack(player, itemstack);
            this.ageUp((int)((float)(-this.getGrowingAge() / 20) * 0.1f));
            return InteractionResult.SUCCESS;
        }
        if (itemstack.m_41720_() == Items.f_42409_) {
            this.f_19853_.m_6263_(player, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.m_188501_() * 0.4f + 0.8f);
            if (!this.f_19853_.m_5776_()) {
                this.ignite();
                itemstack.m_41622_(1, (LivingEntity)player, p_213625_1_ -> p_213625_1_.m_21190_(hand));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getCreeperFlashIntensity(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.lastActiveTime, (float)this.timeSinceIgnited) / (float)(this.fuseTime - 2);
    }

    public int getCreeperState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void setCreeperState(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public boolean hasIgnited() {
        return (Boolean)this.f_19804_.m_135370_(IGNITED);
    }

    public void ignite() {
        this.f_19804_.m_135381_(IGNITED, (Object)true);
    }

    protected void spawnLingeringCloud() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloudentity.m_19712_(1.0f);
            areaeffectcloudentity.m_19732_(-0.5f);
            areaeffectcloudentity.m_19740_(10);
            areaeffectcloudentity.m_19734_(areaeffectcloudentity.m_19748_() / 2);
            areaeffectcloudentity.m_19738_(-areaeffectcloudentity.m_19743_() / (float)areaeffectcloudentity.m_19748_());
            for (MobEffectInstance effectinstance : collection) {
                areaeffectcloudentity.m_19716_(new MobEffectInstance(effectinstance));
            }
            this.f_19853_.m_7967_((Entity)areaeffectcloudentity);
        }
    }

    private void consumeItemFromStack(Player player, ItemStack stack) {
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
    }

    public boolean m_6573_(Player player) {
        return !this.m_21523_() && this.getOwnerId() != null;
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    @Override
    public void setOwnerId(@Nullable UUID ownerId) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(ownerId));
    }

    @Override
    @Nullable
    public LivingEntity getOwner() {
        if (!this.f_19853_.m_5776_()) {
            UUID uuid = this.getOwnerId();
            if (uuid == null) {
                return null;
            }
            Entity entity = ((ServerLevel)this.f_19853_).m_8791_(uuid);
            return entity instanceof LivingEntity ? (LivingEntity)entity : null;
        }
        return null;
    }

    public boolean m_6779_(LivingEntity target) {
        return target != this.getOwner() && super.m_6779_(target);
    }

    @Override
    public boolean shouldAttackEntity(LivingEntity target, LivingEntity owner) {
        boolean shouldAttack = true;
        if (target instanceof OwnableMob) {
            shouldAttack = ((OwnableMob)target).getOwner() != owner;
        } else if (target instanceof TamableAnimal) {
            shouldAttack = ((TamableAnimal)target).m_21826_() != owner;
        } else if (target instanceof Player && owner instanceof Player) {
            shouldAttack = ((Player)owner).m_7099_((Player)target);
        }
        return shouldAttack;
    }

    public boolean isConverting() {
        return (Integer)this.m_20088_().m_135370_(CONVERSION_TIME) > -1;
    }

    private void startConversion(int conversionTime) {
        this.setConversionTime(conversionTime);
        this.hasStartedConverting = true;
    }

    public int getConversionTime() {
        return (Integer)this.m_20088_().m_135370_(CONVERSION_TIME);
    }

    private void setConversionTime(int conversionTimeIn) {
        this.f_19804_.m_135381_(CONVERSION_TIME, (Object)conversionTimeIn);
    }

    private LivingEntity finishConversion(Level world) {
        Creeper creeperEntity = (Creeper)EntityType.f_20558_.m_20615_(this.f_19853_);
        if (creeperEntity == null) {
            return null;
        }
        creeperEntity.m_20359_((Entity)this);
        if (!this.f_19853_.m_5776_()) {
            creeperEntity.m_6518_((ServerLevelAccessor)((ServerLevel)world), this.f_19853_.m_6436_(creeperEntity.m_20183_()), MobSpawnType.CONVERSION, null, null);
        }
        creeperEntity.m_21557_(this.m_21525_());
        if (this.m_8077_()) {
            creeperEntity.m_6593_(this.m_7770_());
            creeperEntity.m_20340_(this.m_20151_());
        }
        if (this.m_7090_()) {
            creeperEntity.m_20088_().m_135381_(Creeper.f_32274_, (Object)true);
        }
        if (this.m_21532_()) {
            creeperEntity.m_21530_();
        }
        if (this.m_21523_()) {
            if (this.m_21524_() != null) {
                creeperEntity.m_21463_(this.m_21524_(), true);
            }
            this.m_21455_(true, false);
        }
        if (this.m_20202_() != null) {
            creeperEntity.m_20329_(this.m_20202_());
        }
        creeperEntity.m_20331_(this.m_20147_());
        creeperEntity.m_21153_(creeperEntity.m_21233_());
        this.f_20890_ = true;
        this.m_146870_();
        this.f_19853_.m_7967_((Entity)creeperEntity);
        this.m_5496_((SoundEvent)SRSounds.ENTITY_CREEPIE_GROW.get(), 1.0f, 1.0f);
        return creeperEntity;
    }

    public Team m_5647_() {
        LivingEntity owner = this.getOwner();
        if (owner != null) {
            return owner.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean m_7307_(Entity entityIn) {
        LivingEntity owner = this.getOwner();
        if (entityIn == owner) {
            return true;
        }
        if (owner != null) {
            return owner.m_7307_(entityIn);
        }
        return super.m_7307_(entityIn);
    }
}

