/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure;

import io.github.mortuusars.exposure.data.storage.IServersideExposureStorage;
import io.github.mortuusars.exposure.data.storage.ServersideExposureStorage;
import io.github.mortuusars.exposure.data.transfer.ExposureReceiver;
import io.github.mortuusars.exposure.data.transfer.ExposureSender;
import io.github.mortuusars.exposure.data.transfer.IExposureReceiver;
import io.github.mortuusars.exposure.data.transfer.IExposureSender;
import io.github.mortuusars.exposure.network.Packets;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;

public class ExposureServer {
    private static IServersideExposureStorage exposureStorage;
    private static IExposureSender exposureSender;
    private static IExposureReceiver exposureReceiver;

    public static void init(MinecraftServer server) {
        exposureStorage = new ServersideExposureStorage(() -> server.m_129783_().m_8895_(), () -> server.m_129843_(LevelResource.f_78182_));
        exposureSender = new ExposureSender((packet, player) -> Packets.sendToClient(packet, (ServerPlayer)player));
        exposureReceiver = new ExposureReceiver(exposureStorage);
    }

    public static IServersideExposureStorage getExposureStorage() {
        return exposureStorage;
    }

    public static IExposureSender getExposureSender() {
        return exposureSender;
    }

    public static IExposureReceiver getExposureReceiver() {
        return exposureReceiver;
    }
}

