/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.capture.processing;

import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

public class Blur {
    public static BufferedImage applyGaussianBlur(BufferedImage image, int radius) {
        int size = radius * 2 + 1;
        float[] kernelData = Blur.createGaussianKernel(radius);
        Kernel kernel = new Kernel(size, size, kernelData);
        ConvolveOp convolveOp = new ConvolveOp(kernel);
        BufferedImage blurredImage = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        convolveOp.filter(image, blurredImage);
        return blurredImage;
    }

    private static float[] createGaussianKernel(int radius) {
        int i;
        int size = radius * 2 + 1;
        float[] kernelData = new float[size * size];
        double sigma = (double)radius / 3.0;
        double twoSigmaSquare = 2.0 * sigma * sigma;
        double sigmaRoot = Math.sqrt(twoSigmaSquare * Math.PI);
        double total = 0.0;
        int index = 0;
        for (i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                double distance = (double)(i * i + j * j) / twoSigmaSquare;
                double weight = Math.exp(-distance) / sigmaRoot;
                kernelData[index] = (float)weight;
                total += weight;
                ++index;
            }
        }
        i = 0;
        while (i < kernelData.length) {
            int n = i++;
            kernelData[n] = (float)((double)kernelData[n] / total);
        }
        return kernelData;
    }
}

