/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.camera.infrastructure;

import io.github.mortuusars.exposure.Exposure;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum FilmType implements StringRepresentable
{
    BLACK_AND_WHITE("black_and_white", 255, 255, 255, 1.0f, 1.0f, 1.0f, 1.0f),
    COLOR("color", 180, 130, 110, 1.2f, 0.96f, 0.75f, 1.0f);

    public static final StringRepresentable.EnumCodec<FilmType> CODEC;
    private final String name;
    public final int frameR;
    public final int frameG;
    public final int frameB;
    public final float filmR;
    public final float filmG;
    public final float filmB;
    public final float filmA;

    private FilmType(String name, int frameR, int frameG, int frameB, float filmR, float filmG, float filmB, float filmA) {
        this.name = name;
        this.frameR = frameR;
        this.frameG = frameG;
        this.frameB = frameB;
        this.filmR = filmR;
        this.filmG = filmG;
        this.filmB = filmB;
        this.filmA = filmA;
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    @Nullable
    public static FilmType byName(@Nullable String name) {
        return (FilmType)CODEC.m_216455_(name);
    }

    public ItemStack createItemStack() {
        return new ItemStack(this == COLOR ? (ItemLike)Exposure.Items.COLOR_FILM.get() : (ItemLike)Exposure.Items.BLACK_AND_WHITE_FILM.get());
    }

    public ItemStack createDevelopedItemStack() {
        return new ItemStack(this == COLOR ? (ItemLike)Exposure.Items.DEVELOPED_COLOR_FILM.get() : (ItemLike)Exposure.Items.DEVELOPED_BLACK_AND_WHITE_FILM.get());
    }

    static {
        CODEC = StringRepresentable.m_216439_(FilmType::values);
    }
}

