/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.data.Filters;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Ingredient;

public class FiltersResourceLoader
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String DIRECTORY = "filters";

    public FiltersResourceLoader() {
        super(GSON, DIRECTORY);
    }

    protected void apply(Map<ResourceLocation, JsonElement> content, ResourceManager resourceManager, ProfilerFiller profiler) {
        ConcurrentHashMap<Ingredient, ResourceLocation> filters = new ConcurrentHashMap<Ingredient, ResourceLocation>();
        LogUtils.getLogger().info("Loading exposure filters:");
        for (Map.Entry<ResourceLocation, JsonElement> entry : content.entrySet()) {
            if (!entry.getKey().m_135827_().equals("exposure")) continue;
            try {
                JsonObject jsonObject = entry.getValue().getAsJsonObject();
                JsonElement item = jsonObject.get("item");
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)item);
                if (ingredient.m_43947_()) {
                    throw new IllegalArgumentException("'item' cannot be empty.");
                }
                String shader = jsonObject.get("shader").getAsString();
                filters.put(ingredient, new ResourceLocation(shader));
                LogUtils.getLogger().info("Filter [" + entry.getKey() + ", " + shader + "] added.");
            }
            catch (Exception e) {
                LogUtils.getLogger().error(e.toString());
            }
        }
        if (filters.isEmpty()) {
            LogUtils.getLogger().info("No filters have been loaded.");
        }
        Filters.reload(filters);
    }
}

