/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data.storage;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExposureSavedData
extends SavedData {
    public static final String TYPE_PROPERTY = "Type";
    public static final String WAS_PRINTED_PROPERTY = "WasPrinted";
    public static final String TIMESTAMP_PROPERTY = "Timestamp";
    private final int width;
    private final int height;
    private final byte[] pixels;
    private final CompoundTag properties;

    public ExposureSavedData(int width, int height, byte[] pixels, CompoundTag properties) {
        Preconditions.checkArgument((width >= 0 ? 1 : 0) != 0, (Object)"Width cannot be negative.");
        Preconditions.checkArgument((height >= 0 ? 1 : 0) != 0, (Object)"Height cannot be negative.");
        if (pixels.length > width * height) {
            LogUtils.getLogger().warn("Pixel count was larger that it supposed to be. This shouldn't happen.");
        }
        this.width = width;
        this.height = height;
        this.pixels = pixels;
        this.properties = properties;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getPixels() {
        return this.pixels;
    }

    public byte getPixel(int x, int y) {
        return this.pixels[y * this.width + x];
    }

    public void setPixel(int x, int y, byte value) {
        Preconditions.checkArgument((x >= 0 && x < this.width ? 1 : 0) != 0, (Object)("X=" + x + " is out of bounds for Width=" + this.width));
        Preconditions.checkArgument((y >= 0 && y < this.height ? 1 : 0) != 0, (Object)("Y=" + x + " is out of bounds for Height=" + this.height));
        this.pixels[y * this.width + x] = value;
    }

    public CompoundTag getProperties() {
        return this.properties;
    }

    @Nullable
    public FilmType getType() {
        String typeString = this.properties.m_128461_(TYPE_PROPERTY);
        return FilmType.byName(typeString);
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag compoundTag) {
        compoundTag.m_128405_("width", this.width);
        compoundTag.m_128405_("height", this.height);
        compoundTag.m_128382_("pixels", this.pixels);
        compoundTag.m_128365_("properties", (Tag)this.properties);
        return compoundTag;
    }

    public static ExposureSavedData load(CompoundTag compoundTag) {
        CompoundTag properties = compoundTag.m_128469_("properties");
        if (!properties.m_128441_(TYPE_PROPERTY)) {
            properties.m_128359_(TYPE_PROPERTY, compoundTag.m_128471_("black_and_white") ? "black_and_white" : "color");
        }
        if (!properties.m_128441_(WAS_PRINTED_PROPERTY)) {
            properties.m_128379_(WAS_PRINTED_PROPERTY, compoundTag.m_128471_("printed"));
        }
        return new ExposureSavedData(compoundTag.m_128451_("width"), compoundTag.m_128451_("height"), compoundTag.m_128463_("pixels"), properties);
    }
}

