/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data.transfer;

import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.data.transfer.IExposureSender;
import io.github.mortuusars.exposure.network.packet.ExposureDataPartPacket;
import java.util.function.BiConsumer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class ExposureSender
implements IExposureSender {
    private static final int PART_SIZE = 30000;
    private final BiConsumer<ExposureDataPartPacket, @Nullable Player> packetSender;

    public ExposureSender(BiConsumer<ExposureDataPartPacket, @Nullable Player> packetSender) {
        this.packetSender = packetSender;
    }

    @Override
    public void send(String id, ExposureSavedData exposureData) {
        this.sendTo(null, id, exposureData);
    }

    @Override
    public void sendTo(@Nullable Player player, String id, ExposureSavedData exposureData) {
        byte[][] parts = this.splitToParts(exposureData.getPixels(), 30000);
        int offset = 0;
        for (byte[] part : parts) {
            ExposureDataPartPacket packet = new ExposureDataPartPacket(id, exposureData.getWidth(), exposureData.getHeight(), exposureData.getProperties(), offset, part);
            this.packetSender.accept(packet, player);
            offset += 30000;
        }
    }

    private byte[][] splitToParts(byte[] input, int partSize) {
        int parts = (int)Math.ceil((double)input.length / (double)partSize);
        byte[][] output = new byte[parts][];
        for (int part = 0; part < parts; ++part) {
            int start = part * partSize;
            int length = Math.min(input.length - start, partSize);
            byte[] bytes = new byte[length];
            System.arraycopy(input, start, bytes, 0, length);
            output[part] = bytes;
        }
        return output;
    }
}

