/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.gui.component;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.render.PhotographRenderer;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PhotographTooltip
implements ClientTooltipComponent,
TooltipComponent {
    public static final int SIZE = 72;
    private final List<ItemAndStack<PhotographItem>> photographs;

    public PhotographTooltip(ItemStack photographStack) {
        Preconditions.checkArgument((boolean)(photographStack.m_41720_() instanceof PhotographItem), (Object)(photographStack + " is not a PhotographItem."));
        this.photographs = List.of(new ItemAndStack(photographStack));
    }

    public PhotographTooltip(ItemAndStack<StackedPhotographsItem> stackedPhotographs) {
        this.photographs = stackedPhotographs.getItem().getPhotographs(stackedPhotographs.getStack());
    }

    public int m_142069_(@NotNull Font font) {
        return 72;
    }

    public int m_142103_() {
        return 74;
    }

    public void m_183452_(Font font, int mouseX, int mouseY, PoseStack poseStack, ItemRenderer itemRenderer, int blitOffset) {
        int photographsCount = this.photographs.size();
        int additionalPhotographs = Math.min(2, photographsCount - 1);
        poseStack.m_85836_();
        poseStack.m_85837_((double)mouseX, (double)mouseY, 500.0);
        float scale = 72.0f / (float)ExposureClient.getExposureRenderer().getSize();
        float nextPhotographOffset = PhotographRenderer.getStackedPhotographOffset() / (float)ExposureClient.getExposureRenderer().getSize();
        poseStack.m_85841_(scale *= 1.0f - (float)additionalPhotographs * nextPhotographOffset, scale, 1.0f);
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        PhotographRenderer.renderStackedPhotographs(this.photographs, poseStack, (MultiBufferSource)bufferSource, 0xF000F0, 255, 255, 255, 255);
        bufferSource.m_109911_();
        poseStack.m_85849_();
        if (photographsCount > 1) {
            poseStack.m_85836_();
            String count = Integer.toString(photographsCount);
            int fontWidth = Minecraft.m_91087_().f_91062_.m_92895_(count);
            float fontScale = 1.6f;
            poseStack.m_85837_((double)((float)mouseX + (float)ExposureClient.getExposureRenderer().getSize() * scale - 2.0f - (float)fontWidth * fontScale), (double)((float)mouseY + (float)ExposureClient.getExposureRenderer().getSize() * scale - 2.0f - 8.0f * fontScale), 10.0);
            poseStack.m_85841_(fontScale, fontScale, fontScale);
            font.m_92883_(poseStack, count, 0.0f, 0.0f, -1);
            poseStack.m_85849_();
        }
    }
}

