/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.entity.PhotographEntity;
import io.github.mortuusars.exposure.render.PhotographRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PhotographEntityRenderer<T extends PhotographEntity>
extends EntityRenderer<T> {
    public PhotographEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T pEntity) {
        return InventoryMenu.f_39692_;
    }

    public boolean shouldRender(T livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return super.m_5523_(livingEntity, camera, camX, camY, camZ);
    }

    public void render(@NotNull T entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        int brightness;
        super.m_7392_(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        boolean invisible = entity.m_20145_();
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(entity.m_146909_()));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entity.m_146908_()));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_((float)((PhotographEntity)((Object)entity)).getRotation() * 360.0f / 4.0f));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        poseStack.m_85837_(-0.5, -0.5, 0.02625);
        float scale = 1.0f / (float)ExposureClient.getExposureRenderer().getSize();
        poseStack.m_85841_(scale, scale, -scale);
        switch (entity.m_6350_()) {
            case DOWN: {
                int n = 210;
                break;
            }
            case UP: {
                int n = 255;
                break;
            }
            default: {
                int n = brightness = 235;
            }
        }
        if (((PhotographEntity)((Object)entity)).isGlowing()) {
            packedLight = 0xF000F0;
        }
        ItemStack item = ((PhotographEntity)((Object)entity)).getItem();
        PhotographRenderer.render(item, !invisible, true, poseStack, bufferSource, packedLight, brightness, brightness, brightness, 255);
        poseStack.m_85849_();
    }
}

