/*
 * Decompiled with CFR 0.152.
 */
package me.steinborn.krypton.mixin.shared.network.flushconsolidation;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import me.steinborn.krypton.mod.shared.network.util.AutoFlushUtil;
import me.steinborn.krypton.mod.shared.player.KryptonServerPlayerEntity;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.entity.EntityAccess;
import org.apache.commons.lang3.mutable.MutableObject;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChunkMap.class})
public abstract class ThreadedAnvilChunkStorageMixin {
    @Shadow
    @Final
    private Int2ObjectMap<ChunkMap.TrackedEntity> f_140150_;
    @Shadow
    @Final
    private PlayerMap f_140149_;
    @Shadow
    @Final
    private ServerLevel f_140133_;
    @Shadow
    @Final
    private ChunkMap.DistanceManager f_140145_;
    @Shadow
    private int f_140126_;

    @Shadow
    public static boolean m_200878_(int x1, int y1, int x2, int y2, int maxDistance) {
        throw new AssertionError((Object)"pedantic");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    public void m_140192_(ServerPlayer player, boolean added) {
        boolean doesNotGenerateChunks = this.m_140329_(player);
        boolean isWatchingWorld = !this.f_140149_.m_8260_(player);
        int chunkPosX = SectionPos.m_123171_((int)player.m_146903_());
        int chunkPosZ = SectionPos.m_123171_((int)player.m_146907_());
        AutoFlushUtil.setAutoFlush(player, false);
        try {
            if (added) {
                this.f_140149_.m_8252_(ChunkPos.m_45589_((int)chunkPosX, (int)chunkPosZ), player, doesNotGenerateChunks);
                this.m_140373_(player);
                if (!doesNotGenerateChunks) {
                    this.f_140145_.m_140802_(SectionPos.m_235861_((EntityAccess)player), player);
                }
                this.sendSpiralChunkWatchPackets(player);
            } else {
                SectionPos chunkSectionPos = player.m_8965_();
                this.f_140149_.m_8249_(chunkSectionPos.m_123251_().m_45588_(), player);
                if (isWatchingWorld) {
                    this.f_140145_.m_140828_(chunkSectionPos, player);
                }
                this.unloadChunks(player, chunkPosX, chunkPosZ, this.f_140126_);
            }
        }
        finally {
            AutoFlushUtil.setAutoFlush(player, true);
        }
    }

    @Overwrite
    public void m_140184_(ServerPlayer player) {
        boolean movedSections;
        for (ChunkMap.TrackedEntity entityTracker : this.f_140150_.values()) {
            if (entityTracker.f_140472_ == player) {
                entityTracker.m_140487_(this.f_140133_.m_6907_());
                continue;
            }
            entityTracker.m_140497_(player);
        }
        SectionPos oldPos = player.m_8965_();
        SectionPos newPos = SectionPos.m_235861_((EntityAccess)player);
        boolean isWatchingWorld = this.f_140149_.m_8262_(player);
        boolean noChunkGen = this.m_140329_(player);
        boolean bl = movedSections = !oldPos.equals((Object)newPos);
        if (movedSections || isWatchingWorld != noChunkGen) {
            this.m_140373_(player);
            if (!isWatchingWorld) {
                this.f_140145_.m_140828_(oldPos, player);
            }
            if (!noChunkGen) {
                this.f_140145_.m_140802_(newPos, player);
            }
            if (!isWatchingWorld && noChunkGen) {
                this.f_140149_.m_8256_(player);
            }
            if (isWatchingWorld && !noChunkGen) {
                this.f_140149_.m_8258_(player);
            }
            long oldChunkPos = ChunkPos.m_45589_((int)oldPos.m_123341_(), (int)oldPos.m_123343_());
            long newChunkPos = ChunkPos.m_45589_((int)newPos.m_123341_(), (int)newPos.m_123343_());
            this.f_140149_.m_8245_(oldChunkPos, newChunkPos, player);
        }
        if (player.f_19853_ == this.f_140133_) {
            this.sendChunkWatchPackets(oldPos, player);
        }
    }

    @Inject(method={"tickEntityMovement"}, at={@At(value="HEAD")})
    public void disableAutoFlushForEntityTracking(CallbackInfo info) {
        for (ServerPlayer player : this.f_140133_.m_6907_()) {
            AutoFlushUtil.setAutoFlush(player, false);
        }
    }

    @Inject(method={"tickEntityMovement"}, at={@At(value="RETURN")})
    public void enableAutoFlushForEntityTracking(CallbackInfo info) {
        for (ServerPlayer player : this.f_140133_.m_6907_()) {
            AutoFlushUtil.setAutoFlush(player, true);
        }
    }

    @Shadow
    public abstract void m_183754_(ServerPlayer var1, ChunkPos var2, MutableObject<ClientboundLevelChunkWithLightPacket> var3, boolean var4, boolean var5);

    @Shadow
    protected abstract boolean m_140329_(ServerPlayer var1);

    @Shadow
    protected abstract SectionPos m_140373_(ServerPlayer var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendChunkWatchPackets(SectionPos oldPos, ServerPlayer player) {
        AutoFlushUtil.setAutoFlush(player, false);
        try {
            int oldChunkX = oldPos.m_123170_();
            int oldChunkZ = oldPos.m_123222_();
            int newChunkX = SectionPos.m_123171_((int)player.m_146903_());
            int newChunkZ = SectionPos.m_123171_((int)player.m_146907_());
            int playerViewDistance = this.getPlayerViewDistance(player);
            if (this.shouldReloadAllChunks(player)) {
                if (player instanceof KryptonServerPlayerEntity) {
                    KryptonServerPlayerEntity kryptonPlayer = (KryptonServerPlayerEntity)player;
                    kryptonPlayer.setNeedsChunksReloaded(false);
                }
                for (int curX = newChunkX - this.f_140126_ - 1; curX <= newChunkX + this.f_140126_ + 1; ++curX) {
                    for (int curZ = newChunkZ - this.f_140126_ - 1; curZ <= newChunkZ + this.f_140126_ + 1; ++curZ) {
                        ChunkPos chunkPos = new ChunkPos(curX, curZ);
                        boolean inNew = ThreadedAnvilChunkStorageMixin.m_200878_(curX, curZ, newChunkX, newChunkZ, playerViewDistance);
                        this.m_183754_(player, chunkPos, (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), true, inNew);
                    }
                }
                this.sendSpiralChunkWatchPackets(player);
            } else if (Math.abs(oldChunkX - newChunkX) > playerViewDistance * 2 || Math.abs(oldChunkZ - newChunkZ) > playerViewDistance * 2) {
                this.unloadChunks(player, oldChunkX, oldChunkZ, this.f_140126_);
                this.sendSpiralChunkWatchPackets(player);
            } else {
                int minSendChunkX = Math.min(newChunkX, oldChunkX) - playerViewDistance - 1;
                int minSendChunkZ = Math.min(newChunkZ, oldChunkZ) - playerViewDistance - 1;
                int maxSendChunkX = Math.max(newChunkX, oldChunkX) + playerViewDistance + 1;
                int maxSendChunkZ = Math.max(newChunkZ, oldChunkZ) + playerViewDistance + 1;
                for (int curX = minSendChunkX; curX <= maxSendChunkX; ++curX) {
                    for (int curZ = minSendChunkZ; curZ <= maxSendChunkZ; ++curZ) {
                        ChunkPos chunkPos = new ChunkPos(curX, curZ);
                        boolean inOld = ThreadedAnvilChunkStorageMixin.m_200878_(curX, curZ, oldChunkX, oldChunkZ, playerViewDistance);
                        boolean inNew = ThreadedAnvilChunkStorageMixin.m_200878_(curX, curZ, newChunkX, newChunkZ, playerViewDistance);
                        this.m_183754_(player, chunkPos, (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), inOld, inNew);
                    }
                }
            }
        }
        finally {
            AutoFlushUtil.setAutoFlush(player, true);
        }
    }

    private void sendSpiralChunkWatchPackets(ServerPlayer player) {
        int chunkPosX = SectionPos.m_123171_((int)player.m_146903_());
        int chunkPosZ = SectionPos.m_123171_((int)player.m_146907_());
        int playerViewDistance = this.getPlayerViewDistance(player) + 1;
        int x = 0;
        int z = 0;
        int dx = 0;
        int dz = -1;
        int t = playerViewDistance * 2;
        int maxI = t * t * 2;
        for (int i = 0; i < maxI; ++i) {
            if (-playerViewDistance <= x && x <= playerViewDistance && -playerViewDistance <= z && z <= playerViewDistance) {
                boolean inNew = ThreadedAnvilChunkStorageMixin.m_200878_(chunkPosX, chunkPosZ, chunkPosX + x, chunkPosZ + z, playerViewDistance);
                this.m_183754_(player, new ChunkPos(chunkPosX + x, chunkPosZ + z), (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), false, inNew);
            }
            if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                t = dx;
                dx = -dz;
                dz = t;
            }
            x += dx;
            z += dz;
        }
    }

    private void unloadChunks(ServerPlayer player, int chunkPosX, int chunkPosZ, int distance) {
        for (int curX = chunkPosX - distance - 1; curX <= chunkPosX + distance + 1; ++curX) {
            for (int curZ = chunkPosZ - distance - 1; curZ <= chunkPosZ + distance + 1; ++curZ) {
                ChunkPos chunkPos = new ChunkPos(curX, curZ);
                this.m_183754_(player, chunkPos, (MutableObject<ClientboundLevelChunkWithLightPacket>)new MutableObject(), true, false);
            }
        }
    }

    private int getPlayerViewDistance(ServerPlayer playerEntity) {
        KryptonServerPlayerEntity kryptonPlayerEntity;
        return playerEntity instanceof KryptonServerPlayerEntity ? ((kryptonPlayerEntity = (KryptonServerPlayerEntity)playerEntity).getPlayerViewDistance() != -1 ? Math.min(this.f_140126_, kryptonPlayerEntity.getPlayerViewDistance() + 1) : this.f_140126_) : this.f_140126_;
    }

    private boolean shouldReloadAllChunks(ServerPlayer playerEntity) {
        KryptonServerPlayerEntity kryptonPlayerEntity;
        return playerEntity instanceof KryptonServerPlayerEntity && (kryptonPlayerEntity = (KryptonServerPlayerEntity)playerEntity).getNeedsChunksReloaded();
    }
}

