/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.slotify;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Locale;

public class ColorUtils {
    public static final Codec<Integer> CODEC = Codec.either((Codec)Codec.intRange((int)0, (int)-1), (Codec)Codec.STRING.flatXmap(ColorUtils::isValidStringOrError, s -> ColorUtils.isValidStringOrError(s).map(ColorUtils::formatString))).xmap(either -> (Integer)either.map(integer -> integer, s -> Integer.parseUnsignedInt(s, 16)), integer -> Either.right((Object)("#" + String.format("%08X", integer))));

    private static String formatString(String s) {
        return "#" + s.toUpperCase(Locale.ROOT);
    }

    public static DataResult<String> isValidStringOrError(String s) {
        String st = s;
        if (s.startsWith("0x")) {
            st = s.substring(2);
        } else if (s.startsWith("#")) {
            st = s.substring(1);
        }
        if (st.length() > 8) {
            return DataResult.error((String)"Invalid color format. Hex value must have up to 8 characters.");
        }
        try {
            int parsedValue = Integer.parseUnsignedInt(st, 16);
            return DataResult.success((Object)st);
        }
        catch (NumberFormatException e) {
            return DataResult.error((String)"Invalid color format. Must be in hex format (0xff00ff00, #ff00ff00, ff00ff00) or integer value");
        }
    }

    public static boolean isValidString(String s) {
        return ColorUtils.isValidStringOrError(s).result().isPresent();
    }
}

