/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.slotify;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.slotify.PlatStuff;
import net.mehvahdjukaar.slotify.SimpleSprite;
import net.mehvahdjukaar.slotify.SlotModifier;
import net.mehvahdjukaar.slotify.SpecialOffset;
import net.mehvahdjukaar.slotify.WidgetModifier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public record GuiModifier(Type type, String target, List<SlotModifier> slotModifiers, int titleX, int titleY, int labelX, int labelY, List<SimpleSprite> sprites, List<WidgetModifier> widgetModifiers, Map<String, SpecialOffset> specialOffsets) {
    public static final Codec<GuiModifier> CODEC = RecordCodecBuilder.create(i -> i.group((App)StringRepresentable.m_216439_(Type::values).fieldOf("target_type").forGetter(GuiModifier::type), (App)Codec.STRING.xmap(PlatStuff::remapName, PlatStuff::remapName).fieldOf("target").forGetter(GuiModifier::target), (App)SlotModifier.CODEC.listOf().optionalFieldOf("slot_modifiers", List.of()).forGetter(GuiModifier::slotModifiers), (App)Codec.INT.optionalFieldOf("title_x_offset", (Object)0).forGetter(GuiModifier::titleX), (App)Codec.INT.optionalFieldOf("title_y_offset", (Object)0).forGetter(GuiModifier::titleY), (App)Codec.INT.optionalFieldOf("label_x_offset", (Object)0).forGetter(GuiModifier::labelX), (App)Codec.INT.optionalFieldOf("label_y_offset", (Object)0).forGetter(GuiModifier::labelY), (App)SimpleSprite.CODEC.listOf().optionalFieldOf("sprites", List.of()).forGetter(GuiModifier::sprites), (App)WidgetModifier.CODEC.listOf().optionalFieldOf("widget_modifiers", List.of()).forGetter(GuiModifier::widgetModifiers), (App)Codec.unboundedMap((Codec)Codec.STRING, SpecialOffset.CODEC).optionalFieldOf("special_offsets", Map.of()).forGetter(GuiModifier::specialOffsets)).apply((Applicative)i, GuiModifier::new)).comapFlatMap(instance -> {
        Optional error;
        if (instance.type == Type.MENU_ID && (error = ResourceLocation.m_135837_((String)instance.target).error()).isPresent()) {
            return DataResult.error((String)((DataResult.PartialResult)error.get()).message());
        }
        if ((instance.type == Type.SCREEN_CLASS || instance.type == Type.SCREEN_TITLE) && instance.slotModifiers.stream().anyMatch(SlotModifier::hasOffset)) {
            return DataResult.error((String)"Slot modifiers cannot alter position when using a screen_class or screen_title target_type. Use menu_id or menu_class instead");
        }
        return DataResult.success((Object)instance);
    }, Function.identity());

    public boolean targetsClass() {
        return this.type != Type.MENU_ID && this.type != Type.SCREEN_TITLE;
    }

    public boolean targetsMenuId() {
        return this.type == Type.MENU_ID;
    }

    public static enum Type implements StringRepresentable
    {
        MENU_ID,
        MENU_CLASS,
        SCREEN_CLASS,
        SCREEN_TITLE;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

