/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.slotify;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.slotify.GuiModifier;
import net.mehvahdjukaar.slotify.ScreenModifier;
import net.mehvahdjukaar.slotify.SlotModifier;
import net.mehvahdjukaar.slotify.Slotify;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;

public class GuiModifierManager
extends SimpleJsonResourceReloadListener {
    private static final Map<MenuType<?>, Int2ObjectArrayMap<SlotModifier>> SLOTS_BY_MENU_ID = new IdentityHashMap();
    private static final Map<Class<?>, Int2ObjectArrayMap<SlotModifier>> SLOTS_BY_CLASS = new IdentityHashMap();
    private static final Map<String, Int2ObjectArrayMap<SlotModifier>> SLOTS_BY_TITLE = new HashMap<String, Int2ObjectArrayMap<SlotModifier>>();
    public static final Map<MenuType<?>, ScreenModifier> BY_MENU_ID = new IdentityHashMap();
    public static final Map<Class<?>, ScreenModifier> BY_CLASS = new IdentityHashMap();
    public static final Map<String, ScreenModifier> BY_TITLE = new HashMap<String, ScreenModifier>();
    private static final ResourceLocation INVENTORY = new ResourceLocation("inventory");

    public GuiModifierManager() {
        super(new GsonBuilder().setPrettyPrinting().create(), "gui_modifiers");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        SLOTS_BY_MENU_ID.clear();
        SLOTS_BY_CLASS.clear();
        SLOTS_BY_TITLE.clear();
        BY_MENU_ID.clear();
        BY_CLASS.clear();
        BY_TITLE.clear();
        ArrayList<GuiModifier> allModifiers = new ArrayList<GuiModifier>();
        for (JsonElement o : object.values()) {
            DataResult result = GuiModifier.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)o);
            GuiModifier modifier = (GuiModifier)result.getOrThrow(false, e -> Slotify.LOGGER.error("Failed to parse menu modifier: {}", e));
            allModifiers.add(modifier);
        }
        for (GuiModifier mod : allModifiers) {
            if (mod.targetsClass()) {
                try {
                    String target = mod.target();
                    Class cl = target.equals("InventoryMenu") ? InventoryMenu.class : (target.equals("ItemPickerMenu") ? CreativeModeInventoryScreen.ItemPickerMenu.class : Class.forName(target));
                    BY_CLASS.merge(cl, new ScreenModifier(mod), (a, b) -> b.merge((ScreenModifier)a));
                    if (mod.slotModifiers().isEmpty()) continue;
                    Int2ObjectArrayMap map = SLOTS_BY_CLASS.computeIfAbsent(cl, i -> new Int2ObjectArrayMap());
                    GuiModifierManager.unwrapSlots(mod, (Int2ObjectArrayMap<SlotModifier>)map);
                }
                catch (ClassNotFoundException target) {}
                continue;
            }
            if (mod.targetsMenuId()) {
                ResourceLocation menuId = new ResourceLocation(mod.target());
                boolean isInventory = menuId.equals((Object)INVENTORY);
                Optional menu = Registry.f_122863_.m_6612_(menuId);
                if (!menu.isPresent() && !isInventory) continue;
                BY_MENU_ID.merge(menu.orElse(null), new ScreenModifier(mod), (a, b) -> b.merge((ScreenModifier)a));
                if (mod.slotModifiers().isEmpty()) continue;
                Int2ObjectArrayMap map = SLOTS_BY_MENU_ID.computeIfAbsent(menu.orElse(null), i -> new Int2ObjectArrayMap());
                GuiModifierManager.unwrapSlots(mod, (Int2ObjectArrayMap<SlotModifier>)map);
                continue;
            }
            String title = mod.target();
            BY_TITLE.merge(title, new ScreenModifier(mod), (a, b) -> b.merge((ScreenModifier)a));
            if (mod.slotModifiers().isEmpty()) continue;
            Int2ObjectArrayMap map = SLOTS_BY_TITLE.computeIfAbsent(title, i -> new Int2ObjectArrayMap());
            GuiModifierManager.unwrapSlots(mod, (Int2ObjectArrayMap<SlotModifier>)map);
        }
        Slotify.LOGGER.info("Loaded modifiers for: " + SLOTS_BY_MENU_ID.keySet() + " " + SLOTS_BY_CLASS.keySet() + " " + BY_MENU_ID.keySet() + " " + BY_CLASS.keySet());
    }

    private static void unwrapSlots(GuiModifier mod, Int2ObjectArrayMap<SlotModifier> map) {
        for (SlotModifier s : mod.slotModifiers()) {
            for (int i : s.targets().getSlots()) {
                map.merge(i, (Object)s, SlotModifier::merge);
            }
        }
    }

    private static ScreenModifier getScreenModifier(AbstractContainerScreen<?> screen) {
        ScreenModifier m = null;
        AbstractContainerMenu menu = screen.m_6262_();
        if (screen.getClass() == InventoryScreen.class) {
            m = BY_CLASS.get(InventoryMenu.class);
        } else if (screen.getClass() == CreativeModeInventoryScreen.class) {
            m = BY_CLASS.get(CreativeModeInventoryScreen.ItemPickerMenu.class);
        }
        if (menu != null) {
            m = BY_CLASS.get(menu.getClass());
        }
        if (m == null) {
            MenuType type;
            try {
                type = menu.m_6772_();
            }
            catch (Exception e) {
                type = null;
            }
            m = BY_MENU_ID.get(type);
        }
        return m;
    }

    @Nullable
    public static ScreenModifier getGuiModifier(Screen screen) {
        MutableComponent mc;
        ComponentContents componentContents;
        ScreenModifier m = null;
        Component c = screen.m_96636_();
        m = BY_TITLE.get(c.getString());
        if (m == null && c instanceof MutableComponent && (componentContents = (mc = (MutableComponent)c).m_214077_()) instanceof TranslatableContents) {
            TranslatableContents tc = (TranslatableContents)componentContents;
            m = BY_TITLE.get(tc.m_237508_());
        }
        if (m == null) {
            m = BY_CLASS.get(screen.getClass());
        }
        if (m == null && screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen as = (AbstractContainerScreen)screen;
            m = GuiModifierManager.getScreenModifier(as);
        }
        return m;
    }

    @Nullable
    public static SlotModifier getSlotModifier(AbstractContainerScreen<?> screen, Slot slot) {
        MutableComponent mc;
        ComponentContents componentContents;
        Int2ObjectArrayMap<SlotModifier> m = null;
        Component c = screen.m_96636_();
        m = SLOTS_BY_TITLE.get(c.getString());
        if (m == null && c instanceof MutableComponent && (componentContents = (mc = (MutableComponent)c).m_214077_()) instanceof TranslatableContents) {
            TranslatableContents tc = (TranslatableContents)componentContents;
            m = SLOTS_BY_TITLE.get(tc.m_237508_());
        }
        if (m == null) {
            m = SLOTS_BY_CLASS.get(screen.getClass());
        }
        if (m == null) {
            SLOTS_BY_CLASS.get(screen.m_6262_().getClass());
        }
        if (m == null) {
            MenuType type;
            try {
                type = screen.m_6262_().m_6772_();
            }
            catch (Exception e) {
                type = null;
            }
            m = SLOTS_BY_MENU_ID.get(type);
        }
        if (m != null) {
            return (SlotModifier)((Object)m.get(slot.f_40219_));
        }
        return null;
    }

    @Nullable
    public static SlotModifier getSlotModifier(AbstractContainerMenu menu, Slot slot) {
        Int2ObjectArrayMap<SlotModifier> m = SLOTS_BY_CLASS.get(menu.getClass());
        if (m == null) {
            MenuType type;
            try {
                type = menu.m_6772_();
            }
            catch (Exception e) {
                type = null;
            }
            m = SLOTS_BY_MENU_ID.get(type);
        }
        if (m != null) {
            return (SlotModifier)((Object)m.get(slot.f_40219_));
        }
        return null;
    }

    public static void maybeModifySlot(AbstractContainerMenu menu, Slot slot) {
        SlotModifier mod = GuiModifierManager.getSlotModifier(menu, slot);
        if (mod != null) {
            mod.modify(slot);
        }
    }

    public static boolean maybeChangeColor(AbstractContainerScreen<?> screen, Slot slot, PoseStack graphics, int x, int y, int offset) {
        SlotModifier mod = GuiModifierManager.getSlotModifier(screen, slot);
        if (mod != null && mod.hasCustomColor()) {
            mod.renderCustomHighlight(graphics, x, y, offset);
            return false;
        }
        return true;
    }
}

