/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.slotify;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.slotify.ColorUtils;
import net.mehvahdjukaar.slotify.PlatStuff;
import net.mehvahdjukaar.slotify.TargetSlots;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.world.inventory.Slot;

public final class SlotModifier
extends GuiComponent {
    public static final Codec<SlotModifier> CODEC = RecordCodecBuilder.create(i -> i.group((App)TargetSlots.CODEC.fieldOf("slots").forGetter(SlotModifier::targets), (App)ColorUtils.CODEC.optionalFieldOf("color", (Object)-1).forGetter(SlotModifier::color), (App)ColorUtils.CODEC.optionalFieldOf("color_2", (Object)-1).forGetter(SlotModifier::color2), (App)Codec.INT.optionalFieldOf("x_offset", (Object)0).forGetter(SlotModifier::xOffset), (App)Codec.INT.optionalFieldOf("y_offset", (Object)0).forGetter(SlotModifier::yOffset), (App)Codec.INT.optionalFieldOf("z_offset", (Object)0).forGetter(SlotModifier::zOffset), (App)Codec.INT.optionalFieldOf("target_x").forGetter(SlotModifier::targetX), (App)Codec.INT.optionalFieldOf("target_y").forGetter(SlotModifier::targetY), (App)Codec.STRING.xmap(PlatStuff::remapName, PlatStuff::remapName).optionalFieldOf("target_class_name").forGetter(SlotModifier::targetClass)).apply((Applicative)i, SlotModifier::new));
    private final TargetSlots targets;
    private final int color;
    private final int color2;
    private final int xOffset;
    private final int yOffset;
    private final int zOffset;
    private final Optional<Integer> targetX;
    private final Optional<Integer> targetY;
    private final Optional<String> targetClass;

    public SlotModifier(TargetSlots targets, int color, int color2, int xOffset, int yOffset, int zOffset, Optional<Integer> targetX, Optional<Integer> targetY, Optional<String> targetClass) {
        this.targets = targets;
        this.color = color;
        this.color2 = color2;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        this.targetX = targetX;
        this.targetY = targetY;
        this.targetClass = targetClass;
    }

    public void modify(Slot slot) {
        if (this.targetX.isPresent() && slot.f_40220_ != this.targetX.get()) {
            return;
        }
        if (this.targetY.isPresent() && slot.f_40221_ != this.targetY.get()) {
            return;
        }
        if (this.targetClass.isPresent()) {
            String name = this.targetClass.get();
            if (!slot.getClass().getSimpleName().equals(name) && !slot.getClass().getName().equals(name)) {
                return;
            }
        }
        slot.f_40220_ += this.xOffset;
        slot.f_40221_ += this.yOffset;
    }

    public boolean hasCustomColor() {
        return this.color != -1 || this.color2 != -1 || this.zOffset != 0;
    }

    public void renderCustomHighlight(PoseStack graphics, int x, int y, int offset) {
        int c1 = this.color;
        int c2 = this.color2 == -1 ? this.color : this.color2;
        SlotModifier.renderSlotHighlight2(graphics, x, y, c1, c2, offset + this.zOffset);
    }

    public static void renderSlotHighlight2(PoseStack graphics, int x, int y, int slotColor, int slotColor2, int offset) {
        RenderSystem.m_69465_();
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        SlotModifier.m_168740_((PoseStack)graphics, (int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)slotColor, (int)slotColor2, (int)offset);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.m_69482_();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        SlotModifier that = (SlotModifier)((Object)obj);
        return Objects.equals(this.targets, that.targets) && this.color == that.color && this.color2 == that.color2 && this.xOffset == that.xOffset && this.yOffset == that.yOffset;
    }

    public String toString() {
        return "SlotModifier[targets=" + this.targets + ", color=" + this.color + ", color2=" + this.color2 + ", xOffset=" + this.xOffset + ", yOffset=" + this.yOffset + "]";
    }

    public boolean hasOffset() {
        return this.xOffset != 0 || this.yOffset != 0;
    }

    public SlotModifier merge(SlotModifier other) {
        HashSet combinedSlots = new HashSet();
        this.targets.getSlots().forEach(combinedSlots::add);
        other.targets.getSlots().forEach(combinedSlots::add);
        return new SlotModifier(new TargetSlots.ListTarget(new ArrayList<Integer>(combinedSlots)), other.hasCustomColor() ? other.color : this.color, other.hasCustomColor() ? other.color2 : this.color, other.hasOffset() ? other.xOffset : this.xOffset, other.hasOffset() ? other.yOffset : this.yOffset, other.zOffset, other.targetX, other.targetY, other.targetClass);
    }

    public TargetSlots targets() {
        return this.targets;
    }

    public int color() {
        return this.color;
    }

    public int color2() {
        return this.color2;
    }

    public int xOffset() {
        return this.xOffset;
    }

    public int yOffset() {
        return this.yOffset;
    }

    public int zOffset() {
        return this.zOffset;
    }

    public Optional<Integer> targetX() {
        return this.targetX;
    }

    public Optional<Integer> targetY() {
        return this.targetY;
    }

    public Optional<String> targetClass() {
        return this.targetClass;
    }

    public int hashCode() {
        return Objects.hash(this.targets, this.color, this.color2, this.xOffset, this.yOffset, this.targetX, this.targetY, this.targetClass);
    }
}

