/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.slotify.mixins;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.mehvahdjukaar.slotify.GuiModifierManager;
import net.mehvahdjukaar.slotify.ScreenModifier;
import net.mehvahdjukaar.slotify.SlotifyScreen;
import net.mehvahdjukaar.slotify.WidgetModifier;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Screen.class})
public abstract class ScreenMixin
implements SlotifyScreen {
    @Unique
    private ScreenModifier slotify$modifier = null;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(CallbackInfo ci) {
        this.slotify$modifier = GuiModifierManager.getGuiModifier((Screen)this);
    }

    @Override
    public void slotify$renderExtraSprites(PoseStack poseStack) {
        if (this.slotify$modifier != null) {
            RenderSystem.m_69482_();
            this.slotify$modifier.sprites().forEach(r -> r.render(poseStack));
        }
    }

    @Override
    public boolean slotify$hasSprites() {
        return this.slotify$modifier != null && !this.slotify$modifier.sprites().isEmpty();
    }

    @Override
    public ScreenModifier slotify$getModifier() {
        return this.slotify$modifier;
    }

    @Inject(method={"addWidget"}, at={@At(value="HEAD")})
    public <T extends GuiEventListener & NarratableEntry> void modifyWidget2(T listener, CallbackInfoReturnable<T> cir) {
        if (this.slotify$modifier != null && listener instanceof AbstractWidget) {
            AbstractWidget aw = (AbstractWidget)listener;
            for (WidgetModifier m : this.slotify$modifier.widgetModifiers()) {
                m.maybeModify(aw);
            }
        }
    }

    @Inject(method={"addRenderableOnly"}, at={@At(value="HEAD")})
    public <T extends Widget> void modifyRenderable(T listener, CallbackInfoReturnable<T> cir) {
        if (this.slotify$modifier != null && listener instanceof AbstractWidget) {
            AbstractWidget aw = (AbstractWidget)listener;
            for (WidgetModifier m : this.slotify$modifier.widgetModifiers()) {
                m.maybeModify(aw);
            }
        }
    }
}

