/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.blocks;

import cc.cassian.raspberry.compat.BuzzierBeesCompat;
import cc.cassian.raspberry.compat.CavernsAndChasmsCompat;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import vectorwing.farmersdelight.common.tag.ModTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class RaspberryCakeBlock
extends Block {
    public static final IntegerProperty BITES = IntegerProperty.m_61631_((String)"bites", (int)0, (int)6);
    public static final IntegerProperty CANDLE_TYPE = IntegerProperty.m_61631_((String)"candle_type", (int)0, (int)19);
    public static final BooleanProperty LIT = AbstractCandleBlock.f_151895_;
    protected static final VoxelShape[] SHAPE_BY_BITE = new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.m_49796_((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)};
    public final Supplier<Item> cakeSlice;
    public final String cakeSliceItemID;
    private static final Iterable<Vec3> PARTICLE_OFFSETS = ImmutableList.of((Object)new Vec3(0.5, 1.0, 0.5));

    public RaspberryCakeBlock(BlockBehaviour.Properties properties, String cakeSlice) {
        super(properties);
        this.cakeSliceItemID = cakeSlice;
        this.cakeSlice = null;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BITES, (Comparable)Integer.valueOf(0))).m_61124_((Property)CANDLE_TYPE, (Comparable)Integer.valueOf(0))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? 3 : 0;
    }

    protected Iterable<Vec3> getParticleOffsets(BlockState state) {
        return PARTICLE_OFFSETS;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            this.getParticleOffsets(state).forEach(arg4 -> RaspberryCakeBlock.addParticlesAndSound(state, level, arg4.m_82520_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), random));
        }
    }

    private static void addParticlesAndSound(BlockState state, Level level, Vec3 offset, RandomSource random) {
        int candleType = (Integer)state.m_61143_((Property)CANDLE_TYPE);
        float f = random.m_188501_();
        if (f < 0.3f) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, offset.f_82479_, offset.f_82480_, offset.f_82481_, 0.0, 0.0, 0.0);
            if (f < 0.17f) {
                level.m_7785_(offset.f_82479_ + 0.5, offset.f_82480_ + 0.5, offset.f_82481_ + 0.5, SoundEvents.f_144096_, SoundSource.BLOCKS, 1.0f + random.m_188501_(), random.m_188501_() * 0.7f + 0.3f, false);
            }
        }
        if (candleType == 18) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123745_, offset.f_82479_, offset.f_82480_, offset.f_82481_, 0.0, 0.0, 0.0);
        } else if (candleType == 19) {
            level.m_7106_((ParticleOptions)CavernsAndChasmsCompat.getCupricCandleFlame(), offset.f_82479_, offset.f_82480_, offset.f_82481_, 0.0, 0.0, 0.0);
        } else {
            level.m_7106_((ParticleOptions)ParticleTypes.f_175834_, offset.f_82479_, offset.f_82480_, offset.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public ItemStack getCakeSliceItem() {
        if (this.cakeSlice != null) {
            return new ItemStack((ItemLike)this.cakeSlice.get());
        }
        return ((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.cakeSliceItemID))).m_7968_();
    }

    public int getMaxBites() {
        return 7;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_BITE[(Integer)state.m_61143_((Property)BITES)];
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        if (level.f_46443_) {
            if (heldStack.m_204117_(ModTags.KNIVES)) {
                return this.cutSlice(level, pos, state, player);
            }
            if (heldStack.m_204117_(ItemTags.f_144319_)) {
                return this.placeCandle(level, pos, state, player, heldStack);
            }
            if (heldStack.m_150930_(Items.f_42409_) || heldStack.m_150930_(Items.f_42613_)) {
                return this.lightCandle(level, pos, state, player, heldStack);
            }
            if (this.consumeBite(level, pos, state, player) == InteractionResult.SUCCESS) {
                return InteractionResult.SUCCESS;
            }
            if (heldStack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        return heldStack.m_204117_(ModTags.KNIVES) ? this.cutSlice(level, pos, state, player) : (heldStack.m_204117_(ItemTags.f_144319_) ? this.placeCandle(level, pos, state, player, heldStack) : (heldStack.m_150930_(Items.f_42409_) || heldStack.m_150930_(Items.f_42613_) ? this.lightCandle(level, pos, state, player, heldStack) : this.consumeBite(level, pos, state, player)));
    }

    protected InteractionResult consumeBite(Level level, BlockPos pos, BlockState state, Player playerIn) {
        int bites;
        int candleType = (Integer)state.m_61143_((Property)CANDLE_TYPE);
        if (candleType > 0) {
            this.popCandle(level, pos, state, candleType, true);
            return InteractionResult.SUCCESS;
        }
        if (!playerIn.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        ItemStack sliceStack = this.getCakeSliceItem();
        FoodProperties sliceFood = sliceStack.m_41720_().m_41473_();
        playerIn.m_36324_().m_38712_(sliceStack.m_41720_(), sliceStack);
        if (this.getCakeSliceItem().m_41720_().m_41472_() && sliceFood != null) {
            for (Pair pair : sliceFood.m_38749_()) {
                if (level.f_46443_ || pair.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                playerIn.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
        }
        if ((bites = ((Integer)state.m_61143_((Property)BITES)).intValue()) < this.getMaxBites() - 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.m_7471_(pos, false);
        }
        level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    protected InteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Player player) {
        int bites = (Integer)state.m_61143_((Property)BITES);
        int candleType = (Integer)state.m_61143_((Property)CANDLE_TYPE);
        if (candleType > 0) {
            this.popCandle(level, pos, state, candleType, true);
            return InteractionResult.SUCCESS;
        }
        if (bites < this.getMaxBites() - 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.m_7471_(pos, false);
        }
        Direction direction = player.m_6350_().m_122424_();
        ItemUtils.spawnItemEntity((Level)level, (ItemStack)this.getCakeSliceItem(), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.3), (double)((double)pos.m_123343_() + 0.5), (double)((double)direction.m_122429_() * 0.15), (double)0.05, (double)((double)direction.m_122431_() * 0.15));
        level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public void useItem(Player player, ItemStack itemStack) {
        if (!player.m_7500_()) {
            if (itemStack.m_41763_()) {
                itemStack.m_41721_(itemStack.m_41773_() + 1);
                if (itemStack.m_41773_() >= itemStack.m_41776_()) {
                    itemStack.m_41774_(1);
                }
            } else {
                itemStack.m_41774_(1);
            }
        }
    }

    protected InteractionResult placeCandle(Level level, BlockPos pos, BlockState state, Player player, ItemStack heldStack) {
        int bites = (Integer)state.m_61143_((Property)BITES);
        int candleType = (Integer)state.m_61143_((Property)CANDLE_TYPE);
        if (bites == 0 && candleType == 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)CANDLE_TYPE, (Comparable)Integer.valueOf(this.getCandleNum(heldStack))), 3);
            this.useItem(player, heldStack);
        } else if (candleType > 0) {
            this.popCandle(level, pos, state, candleType, true);
        } else {
            return InteractionResult.PASS;
        }
        level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public void popCandle(Level level, BlockPos pos, BlockState state, int candleType, Boolean shouldSet) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && shouldSet.booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            level.m_5594_(null, pos, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            if (shouldSet.booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)CANDLE_TYPE, (Comparable)Integer.valueOf(0)), 3);
                level.m_5594_(null, pos, SoundEvents.f_12639_, SoundSource.PLAYERS, 0.8f, 0.8f);
            }
            ItemUtils.spawnItemEntity((Level)level, (ItemStack)this.getCandleItem(candleType), (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 0.3), (double)((double)pos.m_123343_() + 0.5), (double)0.0, (double)0.05, (double)0.0);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            int candleType = (Integer)state.m_61143_((Property)CANDLE_TYPE);
            if (candleType > 0) {
                this.popCandle(level, pos, state, candleType, false);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    protected InteractionResult lightCandle(Level level, BlockPos pos, BlockState state, Player player, ItemStack heldStack) {
        int candleType = (Integer)state.m_61143_((Property)CANDLE_TYPE);
        Boolean lit = (Boolean)state.m_61143_((Property)LIT);
        if (candleType > 0 && !lit.booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
            this.useItem(player, heldStack);
            level.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!level.f_46443_ && projectile.m_6060_()) {
            int candleType = (Integer)state.m_61143_((Property)CANDLE_TYPE);
            Boolean lit = (Boolean)state.m_61143_((Property)LIT);
            if (candleType > 0 && !lit.booleanValue()) {
                level.m_7731_(hit.m_82425_(), (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
                level.m_5594_(null, hit.m_82425_(), SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public ItemStack getCandleItem(int candleType) {
        if (candleType == 1) {
            return new ItemStack((ItemLike)Items.f_151065_);
        }
        if (candleType == 2) {
            return new ItemStack((ItemLike)Items.f_151066_);
        }
        if (candleType == 3) {
            return new ItemStack((ItemLike)Items.f_151074_);
        }
        if (candleType == 4) {
            return new ItemStack((ItemLike)Items.f_151073_);
        }
        if (candleType == 5) {
            return new ItemStack((ItemLike)Items.f_151082_);
        }
        if (candleType == 6) {
            return new ItemStack((ItemLike)Items.f_151078_);
        }
        if (candleType == 7) {
            return new ItemStack((ItemLike)Items.f_151081_);
        }
        if (candleType == 8) {
            return new ItemStack((ItemLike)Items.f_151067_);
        }
        if (candleType == 9) {
            return new ItemStack((ItemLike)Items.f_151070_);
        }
        if (candleType == 10) {
            return new ItemStack((ItemLike)Items.f_151071_);
        }
        if (candleType == 11) {
            return new ItemStack((ItemLike)Items.f_151080_);
        }
        if (candleType == 12) {
            return new ItemStack((ItemLike)Items.f_151075_);
        }
        if (candleType == 13) {
            return new ItemStack((ItemLike)Items.f_151069_);
        }
        if (candleType == 14) {
            return new ItemStack((ItemLike)Items.f_151077_);
        }
        if (candleType == 15) {
            return new ItemStack((ItemLike)Items.f_151076_);
        }
        if (candleType == 16) {
            return new ItemStack((ItemLike)Items.f_151068_);
        }
        if (candleType == 17) {
            return new ItemStack((ItemLike)Items.f_151072_);
        }
        if (candleType == 18) {
            return new ItemStack((ItemLike)BuzzierBeesCompat.getSoulCandle());
        }
        if (candleType == 19) {
            return new ItemStack((ItemLike)CavernsAndChasmsCompat.getCupricCandle());
        }
        return new ItemStack((ItemLike)Items.f_151065_);
    }

    public int getCandleNum(ItemStack heldStack) {
        if (heldStack.m_150930_(Items.f_151065_)) {
            return 1;
        }
        if (heldStack.m_150930_(Items.f_151066_)) {
            return 2;
        }
        if (heldStack.m_150930_(Items.f_151074_)) {
            return 3;
        }
        if (heldStack.m_150930_(Items.f_151073_)) {
            return 4;
        }
        if (heldStack.m_150930_(Items.f_151082_)) {
            return 5;
        }
        if (heldStack.m_150930_(Items.f_151078_)) {
            return 6;
        }
        if (heldStack.m_150930_(Items.f_151081_)) {
            return 7;
        }
        if (heldStack.m_150930_(Items.f_151067_)) {
            return 8;
        }
        if (heldStack.m_150930_(Items.f_151070_)) {
            return 9;
        }
        if (heldStack.m_150930_(Items.f_151071_)) {
            return 10;
        }
        if (heldStack.m_150930_(Items.f_151080_)) {
            return 11;
        }
        if (heldStack.m_150930_(Items.f_151075_)) {
            return 12;
        }
        if (heldStack.m_150930_(Items.f_151069_)) {
            return 13;
        }
        if (heldStack.m_150930_(Items.f_151077_)) {
            return 14;
        }
        if (heldStack.m_150930_(Items.f_151076_)) {
            return 15;
        }
        if (heldStack.m_150930_(Items.f_151068_)) {
            return 16;
        }
        if (heldStack.m_150930_(Items.f_151072_)) {
            return 17;
        }
        if (heldStack.m_150930_(BuzzierBeesCompat.getSoulCandle().m_5456_())) {
            return 18;
        }
        if (heldStack.m_150930_(CavernsAndChasmsCompat.getCupricCandle().m_5456_())) {
            return 19;
        }
        return 0;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60767_().m_76333_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BITES, CANDLE_TYPE, LIT});
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return this.getMaxBites() - (Integer)blockState.m_61143_((Property)BITES);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

