/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.compat.oreganized.network.packet;

import cc.cassian.raspberry.compat.oreganized.world.KineticDamage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public record KineticHitPacket(int target, double factor) {
    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.target);
        buffer.writeDouble(this.factor);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            Entity target = level.m_6815_(this.target());
            if (target == null) {
                return;
            }
            KineticDamage.spawnParticles(target, this.factor);
        });
        context.setPacketHandled(true);
    }

    public static KineticHitPacket from(FriendlyByteBuf buffer) {
        int target = buffer.readInt();
        double factor = buffer.readDouble();
        return new KineticHitPacket(target, factor);
    }
}

