/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.raspberry.overlay;

import cc.cassian.raspberry.config.ModConfig;
import cc.cassian.raspberry.registry.RaspberryTags;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class OverlayHelpers {
    public static Stream<ItemStack> getContents(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        if (compoundtag == null) {
            return Stream.empty();
        }
        if (compoundtag.m_128441_("Items")) {
            ListTag listtag = compoundtag.m_128437_("Items", 10);
            return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
        }
        if (compoundtag.m_128441_("BlockEntityTag")) {
            CompoundTag compound = compoundtag.m_128469_("BlockEntityTag");
            ListTag listtag = compound.m_128437_("Items", 10);
            return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
        }
        return Stream.empty();
    }

    public static ItemStack checkInventoryForStack(Inventory inventory, TagKey<Item> key, Item item) {
        if (ModConfig.get().searchContainers && inventory.m_204075_(RaspberryTags.CONTAINERS)) {
            for (ItemStack stack : inventory.f_35974_) {
                if (!stack.m_204117_(RaspberryTags.CONTAINERS)) continue;
                List<ItemStack> contents = OverlayHelpers.getContents(stack).toList();
                for (ItemStack content : contents) {
                    if (key != null && content.m_204117_(key)) {
                        return stack;
                    }
                    if (item == null || !content.m_150930_(item)) continue;
                    return stack;
                }
            }
        }
        return ItemStack.f_41583_;
    }
}

