/*
 * Decompiled with CFR 0.152.
 */
package me.juancarloscp52.panorama_screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import me.juancarloscp52.panorama_screen.mixin.PanoramaRendererAccessor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class RotatingCubeMapRenderer {
    private CubeMap cubeMap = TitleScreen.f_96716_;
    private static RotatingCubeMapRenderer INSTANCE;
    private float time = 0.0f;
    private static final ResourceLocation PANORAMA_OVERLAY;
    private boolean doBackgroundFade;
    private long backgroundFadeStart;
    private ResourceLocation overlay = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");

    private RotatingCubeMapRenderer() {
    }

    public static RotatingCubeMapRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RotatingCubeMapRenderer();
        }
        return INSTANCE;
    }

    public void addPanoramaTime(float delta) {
        this.time += delta;
    }

    public void render() {
        this.render(1.0f, false);
    }

    public void render(float alpha, boolean titleScreen) {
        this.cubeMap.m_108849_(Minecraft.m_91087_(), Mth.m_14031_((float)(this.time * 0.001f)) * 5.0f + 25.0f, -this.time * 0.1f, alpha);
        if (!titleScreen) {
            PoseStack matrices = new PoseStack();
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.overlay);
            RenderSystem.m_69478_();
            float f = this.doBackgroundFade ? (float)(Util.m_137550_() - this.backgroundFadeStart) / 1000.0f : 1.0f;
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.doBackgroundFade ? (float)Mth.m_14167_((float)Mth.m_14036_((float)f, (float)0.0f, (float)1.0f)) : 1.0f));
            TitleScreen.m_93160_((PoseStack)matrices, (int)0, (int)0, (int)Minecraft.m_91087_().m_91268_().m_85445_(), (int)Minecraft.m_91087_().m_91268_().m_85446_(), (float)0.0f, (float)0.0f, (int)16, (int)128, (int)16, (int)128);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void update(PanoramaRenderer renderer, ResourceLocation panoramaOverlay, boolean doBackgroundFade, long backgroundFadeStart) {
        this.cubeMap = ((PanoramaRendererAccessor)renderer).getCubeMap();
        this.overlay = panoramaOverlay;
        this.doBackgroundFade = doBackgroundFade;
        this.backgroundFadeStart = backgroundFadeStart;
    }

    public void updateOverlayId(ResourceLocation panoramaOverlay) {
        this.overlay = panoramaOverlay;
    }

    static {
        PANORAMA_OVERLAY = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    }
}

