/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.hardernaturalhealing.config;

import com.mactso.hardernaturalhealing.utility.Utility;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="hardernaturalhealing", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static int debugLevel;
    private static double healingPerSecond;
    private static double maxBonusHitPointTotems;
    private static int attackHealingDelayTicks;
    private static int healthAfterDeath;
    private static int hungerAfterDeath;
    private static double minimumFoodHealingLevel;
    private static double healingExhaustionCost;
    private static double wakeupHealingAmount;
    private static int minimumStarvationHealth;
    private static boolean peacefulHunger;
    private static double extraExhaustionWhenHurt;

    public static void pushDebugValue() {
        Utility.debugMsg(1, "hardernaturalhealing debugLevel:" + debugLevel);
        MyConfig.COMMON.debugLevel.set((Object)debugLevel);
    }

    public static void setHealingPerSecond(double healingPerSecond) {
        MyConfig.healingPerSecond = healingPerSecond;
    }

    public static void setMaxBonusHitPointTotems(double maxBonusHitPointTotems) {
        MyConfig.maxBonusHitPointTotems = maxBonusHitPointTotems;
    }

    public static void setAttackHealingDelayTicks(int attackHealingDelayTicks) {
        MyConfig.attackHealingDelayTicks = attackHealingDelayTicks;
    }

    public static void setMinimumFoodHealingLevel(double minimumFoodHealingLevel) {
        MyConfig.minimumFoodHealingLevel = minimumFoodHealingLevel;
    }

    public static boolean setHealingExhaustionCost(double healingExhaustionCost) {
        MyConfig.healingExhaustionCost = healingExhaustionCost;
        return true;
    }

    public static void setWakeupHealingAmount(double wakeupHealingAmount) {
        MyConfig.wakeupHealingAmount = wakeupHealingAmount;
    }

    public static void setMinimumStarvationHealth(int minimumStarvationHealth) {
        MyConfig.minimumStarvationHealth = minimumStarvationHealth;
    }

    public static int setPeacefulHunger(boolean peacefulHunger) {
        MyConfig.peacefulHunger = peacefulHunger;
        return 1;
    }

    public static void setExtraExhaustionWhenHurt(double extraExhaustionWhenHurt) {
        MyConfig.extraExhaustionWhenHurt = extraExhaustionWhenHurt;
    }

    public static int getDebugLevel() {
        return debugLevel;
    }

    public static void setDebugLevel(int debugLevel) {
        MyConfig.debugLevel = debugLevel;
    }

    public static double getHealingPerSecond() {
        return healingPerSecond;
    }

    public static int getHealthAfterDeath() {
        return healthAfterDeath;
    }

    public static void setHealthAfterDeath(int newValue) {
        healthAfterDeath = newValue;
        MyConfig.COMMON.healthAfterDeath.set((Object)newValue);
    }

    public static int getHungerAfterDeath() {
        return hungerAfterDeath;
    }

    public static void setHungerAfterDeath(int newValue) {
        hungerAfterDeath = newValue;
        MyConfig.COMMON.hungerAfterDeath.set((Object)newValue);
    }

    public static double getMinimumFoodHealingLevel() {
        return minimumFoodHealingLevel;
    }

    public static double getHealingExhaustionCost() {
        return healingExhaustionCost;
    }

    public static double getWakeupHealingAmount() {
        return wakeupHealingAmount;
    }

    public static int getAttackHealingDelayTicks() {
        return attackHealingDelayTicks;
    }

    public static double getMaxBonusHitPointTotems() {
        return maxBonusHitPointTotems;
    }

    public static double getExtraExhaustionWhenHurt() {
        return extraExhaustionWhenHurt;
    }

    public static int getMinimumStarvationHealth() {
        return minimumStarvationHealth;
    }

    public static boolean isPeacefulHunger() {
        return peacefulHunger;
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            MyConfig.bakeConfig();
        }
    }

    public static void bakeConfig() {
        debugLevel = (Integer)MyConfig.COMMON.debugLevel.get();
        attackHealingDelayTicks = (Integer)MyConfig.COMMON.attackHealingDelayTicks.get();
        extraExhaustionWhenHurt = (Double)MyConfig.COMMON.extraExhaustionWhenHurt.get();
        maxBonusHitPointTotems = ((Integer)MyConfig.COMMON.maxBonusHitPointTotems.get()).intValue();
        healingPerSecond = (Double)MyConfig.COMMON.healingPerSecond.get();
        minimumFoodHealingLevel = (Double)MyConfig.COMMON.minimumFoodHealingLevel.get();
        healingExhaustionCost = (Double)MyConfig.COMMON.healingExhaustionCost.get();
        wakeupHealingAmount = (Double)MyConfig.COMMON.wakeupHealingAmount.get();
        minimumStarvationHealth = (Integer)MyConfig.COMMON.minimumStarvationHealth.get();
        peacefulHunger = (Boolean)MyConfig.COMMON.peacefulHunger.get();
        healthAfterDeath = (Integer)MyConfig.COMMON.healthAfterDeath.get();
        hungerAfterDeath = (Integer)MyConfig.COMMON.hungerAfterDeath.get();
        if (debugLevel > 0) {
            System.out.println("HarderNaturalHealing Debug: " + debugLevel);
        }
    }

    public static void pushPeacefulHunger() {
        MyConfig.COMMON.peacefulHunger.set((Object)MyConfig.isPeacefulHunger());
    }

    public static void pushHealingPerSecond() {
        MyConfig.COMMON.healingPerSecond.set((Object)MyConfig.getHealingPerSecond());
    }

    public static void pushAttackHealingDelayTicks() {
        MyConfig.COMMON.attackHealingDelayTicks.set((Object)MyConfig.getAttackHealingDelayTicks());
    }

    public static void pushHungerAfterDeath() {
        MyConfig.COMMON.hungerAfterDeath.set((Object)MyConfig.getHungerAfterDeath());
    }

    public static void pushMinimumFoodHealingLevel() {
        MyConfig.COMMON.minimumFoodHealingLevel.set((Object)MyConfig.getMinimumFoodHealingLevel());
    }

    public static void pushHealingExhaustionCost() {
        MyConfig.COMMON.healingExhaustionCost.set((Object)MyConfig.getHealingExhaustionCost());
    }

    public static void pushWakeupHealingAmount() {
        MyConfig.COMMON.wakeupHealingAmount.set((Object)MyConfig.getWakeupHealingAmount());
    }

    public static void pushExtraExhaustionWhenHurt() {
        MyConfig.COMMON.extraExhaustionWhenHurt.set((Object)MyConfig.getExtraExhaustionWhenHurt());
    }

    public static void pushMinimumStarvationHealth() {
        MyConfig.COMMON.minimumStarvationHealth.set((Object)MyConfig.getMinimumStarvationHealth());
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue debugLevel;
        public final ForgeConfigSpec.IntValue attackHealingDelayTicks;
        public final ForgeConfigSpec.IntValue maxBonusHitPointTotems;
        public final ForgeConfigSpec.IntValue healthAfterDeath;
        public final ForgeConfigSpec.IntValue hungerAfterDeath;
        public final ForgeConfigSpec.DoubleValue extraExhaustionWhenHurt;
        public final ForgeConfigSpec.DoubleValue healingPerSecond;
        public final ForgeConfigSpec.DoubleValue minimumFoodHealingLevel;
        public final ForgeConfigSpec.DoubleValue healingExhaustionCost;
        public final ForgeConfigSpec.DoubleValue wakeupHealingAmount;
        public final ForgeConfigSpec.IntValue minimumStarvationHealth;
        public final ForgeConfigSpec.BooleanValue peacefulHunger;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.push("Harder Natural Healing Control Values");
            this.debugLevel = builder.comment("Debug Level: 0 = Off, 1 = Log, 2 = Chat+Log").translation("hardernaturalhealing.config.debugLevel").defineInRange("debugLevel", () -> 0, 0, 2);
            this.attackHealingDelayTicks = builder.comment("Attack Healing Delay in Ticks").translation("hardernaturalhealing.config.attackHealingDelayTicks").defineInRange("attackHealingDelayTicks", () -> 200, 0, 3600);
            this.maxBonusHitPointTotems = builder.comment("Max Bonus HitPoint Totems").translation("hardernaturalhealing.config.maxBonusHitPointTotems").defineInRange("maxBonusHitPointTotems", () -> 300, 0, 1200);
            this.healingPerSecond = builder.comment("healingPerSecond").translation("hardernaturalhealing.config.healingPerSecond").defineInRange("healingPerSecond", () -> 0.25, 0.0, 10.0);
            this.healthAfterDeath = builder.comment("healthAfterDeath").translation("hardernaturalhealing.config.healthAfterDeath").defineInRange("healthAfterDeath", () -> 20, 0, 20);
            this.hungerAfterDeath = builder.comment("hungerAfterDeath").translation("hardernaturalhealing.config.hungerAfterDeath").defineInRange("hungerAfterDeath", () -> 20, 0, 20);
            this.minimumFoodHealingLevel = builder.comment("minimumFoodHealingLevel").translation("hardernaturalhealing.config.minimumFoodHealingLevel").defineInRange("minimumFoodHealingLevel", () -> 16.0, 0.0, 22.0);
            this.healingExhaustionCost = builder.comment("healingExhaustionCost - Hunger exhausted per healing event.").translation("hardernaturalhealing.config.healingExhaustionCost").defineInRange("healingExhaustionCost", () -> 1.0, 0.0, 10.0);
            this.wakeupHealingAmount = builder.comment("wakeupHealingAmount").translation("hardernaturalhealing.config.wakeupHealingAmount").defineInRange("wakeupHealingAmount", () -> 4.0, 0.0, 10.0);
            this.extraExhaustionWhenHurt = builder.comment("extraExhaustionWhenHurt").translation("hardernaturalhealing.config.extraExhaustionWhenHurt").defineInRange("extraExhaustionWhenHurt", () -> 0.0125, 0.0, 1.0);
            this.minimumStarvationHealth = builder.comment("minimum hit points for peaceful mode starvation.").translation("hardernaturalhealing.config.minimumStarvationHealth").defineInRange("minimumStarvationHealth", () -> 0, 0, 20);
            this.peacefulHunger = builder.comment("Can the player get hungry and maybe even starve to death in peaceful mode.").translation("hardernaturalhealing.config.peacefulHunger").define("peacefulHunger", true);
            builder.pop();
        }
    }
}

