/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.hardernaturalhealing.forgeevents;

import com.mactso.hardernaturalhealing.config.MyConfig;
import com.mactso.hardernaturalhealing.utility.Utility;
import java.lang.reflect.Field;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.coremod.api.ASMAPI;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class PeacefulHealingHandler {
    static float cSat = 0.0f;
    static float cExt = 0.0f;
    static int cFod = 0;
    static int cTim = 0;
    static float sSat = 0.0f;
    static float sExt = 0.0f;
    static int sFod = 0;
    static int sTim = 0;
    static boolean cRegen;
    static boolean sRegen;
    private static Field tickTimer;
    private static final Logger LOGGER;
    static boolean timerAvailable;

    @SubscribeEvent
    public static void onPlayerHealing(TickEvent.PlayerTickEvent event) {
        if (MyConfig.isPeacefulHunger()) {
            FoodData fs = event.player.m_36324_();
            Difficulty difficulty = event.player.f_19853_.m_46791_();
            if (event.phase == TickEvent.Phase.START) {
                MyConfig.setDebugLevel(0);
                if (event.side == LogicalSide.CLIENT) {
                    cRegen = event.player.f_19853_.m_46469_().m_46207_(GameRules.f_46139_);
                    cSat = fs.m_38722_();
                    cExt = fs.m_150380_();
                    cFod = fs.m_38702_();
                    try {
                        cTim = (Integer)tickTimer.get(fs);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.error("Illegal Argument: failed to get client FoodData tickTimer.");
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        LOGGER.error("Illegal Access: failed to get client FoodData tickTimer.");
                        e.printStackTrace();
                    }
                    Utility.debugMsg(2, "(" + event.player.f_19797_ + ") C START cTim:" + cTim + " cSat:" + cSat + " cExt:" + cExt + " cFod:" + cFod + ".");
                } else {
                    sRegen = event.player.f_19853_.m_46469_().m_46207_(GameRules.f_46139_);
                    sSat = fs.m_38722_();
                    sExt = fs.m_150380_();
                    sFod = fs.m_38702_();
                    try {
                        sTim = (Integer)tickTimer.get(fs);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.error("Illegal Argument: failed to get server FoodData tickTimer.");
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        LOGGER.error("Illegal Access: failed to get server FoodData tickTimer.");
                        e.printStackTrace();
                    }
                    Utility.debugMsg(2, "(" + event.player.f_19797_ + ") S START sTim:" + sTim + " sSat:" + sSat + " sExt:" + sExt + " sFod:" + sFod + ".");
                }
            }
            if (event.phase == TickEvent.Phase.END && difficulty == Difficulty.PEACEFUL) {
                MyConfig.setDebugLevel(0);
                if (event.side == LogicalSide.CLIENT) {
                    Utility.debugMsg(2, "(" + event.player.f_19797_ + ") C xENDx cTim:" + cTim + " cSat:" + cSat + " cExt:" + cExt + " cFod:" + cFod + ".");
                    fs.m_38705_(cFod);
                } else {
                    Utility.debugMsg(2, "(" + event.player.f_19797_ + ") S xENDx sTim:" + sTim + " sSat:" + sSat + " sExt:" + sExt + " sFod:" + sFod + ".");
                    if (sExt > fs.m_150380_() && sSat == 0.0f && fs.m_38702_() > 0) {
                        fs.m_38705_(fs.m_38702_() - 1);
                    }
                    if (fs.m_38702_() == 0 && ++sTim > 80) {
                        if (event.player.m_21223_() > (float)MyConfig.getMinimumStarvationHealth()) {
                            event.player.m_6469_(DamageSource.f_19313_, 1.0f);
                        }
                        sTim = 0;
                    }
                    try {
                        tickTimer.setInt(fs, sTim);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.error("Illegal Argument: failed to update FoodData tickTimer.");
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        LOGGER.error("Illegal Access: failed to update FoodData tickTimer.");
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    static {
        tickTimer = null;
        LOGGER = LogManager.getLogger();
        timerAvailable = false;
        try {
            String name = ASMAPI.mapField((String)"f_38699_");
            tickTimer = FoodData.class.getDeclaredField(name);
            tickTimer.setAccessible(true);
            timerAvailable = true;
        }
        catch (Exception e) {
            LOGGER.error("XXX Unexpected Reflection Failure balanceBiomeSpawnValues");
        }
    }
}

