/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.block;

import com.starfish_studios.naturalist.registry.NaturalistRegistry;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlowGoopBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final int MIN_GOOP = 1;
    public static final int MAX_GOOP = 3;
    public static final BooleanProperty WATERLOGGED;
    public static final ToIntFunction<BlockState> LIGHT_EMISSION;
    public static IntegerProperty GOOP;

    public GlowGoopBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)GOOP, (Comparable)Integer.valueOf(1))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private void decreaseGoop(Level level, BlockPos pos, BlockState state) {
        level.m_5594_(null, pos, SoundEvents.f_11964_, SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
        int i = (Integer)state.m_61143_((Property)GOOP);
        if (i <= 1) {
            level.m_46961_(pos, false);
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)GOOP, (Comparable)Integer.valueOf(i - 1)), 2);
            level.m_220407_(GameEvent.f_157794_, pos, GameEvent.Context.m_223722_((BlockState)state));
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.m_6240_(level, player, pos, state, blockEntity, tool);
        this.decreaseGoop(level, pos, state);
    }

    @NotNull
    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return NaturalistRegistry.GLOW_GOOP.get().m_5456_().m_7968_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = context.m_43725_().m_8055_(context.m_8083_());
        if (blockState.m_60713_((Block)this)) {
            return (BlockState)blockState.m_61124_((Property)GOOP, (Comparable)Integer.valueOf(Math.min(3, (Integer)blockState.m_61143_((Property)GOOP) + 1)));
        }
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        boolean bl = fluidState.m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(bl));
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        if (!useContext.m_43722_().m_150930_(this.m_5456_())) {
            BlockPos pos = useContext.m_8083_();
            Level level = useContext.m_43725_();
            if (!level.m_5776_()) {
                this.decreaseGoop(level, pos, state);
                int goop = (Integer)state.m_61143_((Property)GOOP);
                for (int i = 0; i < goop; ++i) {
                    GlowGoopBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)NaturalistRegistry.GLOW_GOOP.get()));
                }
            }
        }
        return !useContext.m_7078_() && useContext.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)GOOP) < 3 || super.m_6864_(state, useContext);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{GOOP, WATERLOGGED});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return context.m_7142_(NaturalistRegistry.GLOW_GOOP.get()) ? Shapes.m_83144_() : Shapes.m_83040_();
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    static {
        GOOP = IntegerProperty.m_61631_((String)"goop", (int)1, (int)3);
        WATERLOGGED = BlockStateProperties.f_61362_;
        LIGHT_EMISSION = blockState -> (Integer)blockState.m_61143_((Property)GOOP) * 5;
    }
}

