/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.naturalist.entity;

import com.starfish_studios.naturalist.entity.ai.goal.FlyingWanderGoal;
import com.starfish_studios.naturalist.registry.NaturalistSoundEvents;
import com.starfish_studios.naturalist.registry.NaturalistTags;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class Vulture
extends PathfinderMob
implements IAnimatable,
FlyingAnimal {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42583_});
    private int ticksSinceEaten;

    public Vulture(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 20, true);
        this.m_21553_(true);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_CACTUS, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_CACTUS, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 4.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new VultureAttackGoal(this, 1.2f, true));
        this.f_21345_.m_25352_(2, (Goal)new VultureSearchForFoodGoal(this, 1.2f, FOOD_ITEMS, 10.0, 20.0));
        this.f_21345_.m_25352_(3, (Goal)new VultureWanderGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, 10, false, false, entity -> entity.m_6095_().m_204039_(NaturalistTags.EntityTypes.VULTURE_HOSTILES) && !FOOD_ITEMS.test(this.m_21205_())));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, false, false, entity -> entity.m_21223_() <= 6.0f && !entity.m_21205_().m_41619_() && !FOOD_ITEMS.test(this.m_21205_())));
    }

    public static boolean checkVultureSpawnRules(EntityType<Vulture> entityType, LevelAccessor state, MobSpawnType type, BlockPos pos, RandomSource random) {
        return state.m_8055_(pos.m_7495_()).m_204336_(NaturalistTags.BlockTags.VULTURES_SPAWNABLE_ON) && state.m_45524_(pos, 0) > 8;
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        if (effectInstance.m_19544_() == MobEffects.f_19612_) {
            return false;
        }
        return super.m_7301_(effectInstance);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return NaturalistSoundEvents.VULTURE_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return NaturalistSoundEvents.VULTURE_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return NaturalistSoundEvents.VULTURE_AMBIENT.get();
    }

    public boolean m_6147_() {
        return false;
    }

    public boolean m_6673_(DamageSource pSource) {
        return pSource.equals(DamageSource.f_19314_) || super.m_6673_(pSource);
    }

    public boolean m_7327_(Entity target) {
        boolean shouldHurt;
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        float knockback = (float)this.m_21133_(Attributes.f_22282_);
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            damage += livingEntity.m_6336_().equals(MobType.f_21641_) ? damage : 0.0f;
            knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if (shouldHurt = target.m_6469_(DamageSource.m_19370_((LivingEntity)this), damage)) {
            if (knockback > 0.0f && target instanceof LivingEntity) {
                ((LivingEntity)target).m_147240_((double)(knockback * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            this.m_19970_((LivingEntity)this, target);
            this.m_21335_(target);
        }
        return shouldHurt;
    }

    public void m_8107_() {
        super.m_8107_();
        this.f_19853_.m_46473_().m_6180_("looting");
        if (!this.f_19853_.f_46443_ && this.m_21531_() && this.m_6084_() && !this.f_20890_ && this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_)) {
            for (ItemEntity itementity : this.f_19853_.m_45976_(ItemEntity.class, this.m_20191_().m_82377_(1.0, 1.0, 1.0))) {
                if (itementity.m_213877_() || itementity.m_32055_().m_41619_() || !this.m_7243_(itementity.m_32055_())) continue;
                this.m_7581_(itementity);
            }
        }
        this.f_19853_.m_46473_().m_7238_();
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.m_6142_()) {
            ++this.ticksSinceEaten;
            ItemStack stack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (stack.m_41720_().m_41472_()) {
                if (this.ticksSinceEaten > 600) {
                    ItemStack finishedStack = stack.m_41671_(this.f_19853_, (LivingEntity)this);
                    if (!finishedStack.m_41619_()) {
                        this.m_8061_(EquipmentSlot.MAINHAND, finishedStack);
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 560 && this.f_19796_.m_188501_() < 0.1f) {
                    this.m_5496_(this.m_7866_(stack), 1.0f, 1.0f);
                    this.f_19853_.m_7605_((Entity)this, (byte)45);
                }
            }
        }
    }

    public void m_7822_(byte id) {
        if (id == 45) {
            ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
            if (!itemStack.m_41619_()) {
                for (int i = 0; i < 8; ++i) {
                    Vec3 vec3 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                    this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemStack), this.m_20185_() + this.m_20154_().f_82479_ / 2.0, this.m_20186_(), this.m_20189_() + this.m_20154_().f_82481_ / 2.0, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
                }
            }
        } else {
            super.m_7822_(id);
        }
    }

    public boolean m_7066_(ItemStack pItemstack) {
        return !FOOD_ITEMS.test(this.m_21205_());
    }

    public boolean m_7252_(ItemStack pStack) {
        return FOOD_ITEMS.test(pStack) && !FOOD_ITEMS.test(this.m_21205_());
    }

    protected void m_7581_(ItemEntity pItemEntity) {
        ItemStack itemstack = pItemEntity.m_32055_();
        if (this.m_7252_(itemstack)) {
            if (!this.m_21205_().m_41619_() && !FOOD_ITEMS.test(this.m_21205_())) {
                this.dropItemStack(this.m_21205_());
            }
            this.m_21053_(pItemEntity);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack);
            this.m_7938_((Entity)pItemEntity, itemstack.m_41613_());
            pItemEntity.m_146870_();
            this.ticksSinceEaten = 0;
        }
    }

    private void dropItemStack(ItemStack pStack) {
        ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), pStack);
        this.f_19853_.m_7967_((Entity)itementity);
    }

    protected PathNavigation m_6037_(Level pLevel) {
        VulturePathNavigation navigation = new VulturePathNavigation((Mob)this, pLevel);
        navigation.m_26440_(false);
        navigation.m_7008_(true);
        navigation.m_26443_(true);
        return navigation;
    }

    public boolean m_6162_() {
        return false;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_29443_() && this.m_20184_().f_82480_ > 0.0) {
            event.getController().setAnimation(new AnimationBuilder().loop("fly2"));
            event.getController().setAnimationSpeed(1.5);
        } else if (this.m_29443_() && this.m_20184_().f_82480_ < 0.0) {
            event.getController().setAnimation(new AnimationBuilder().loop("glide2"));
        } else if (this.m_29443_()) {
            event.getController().setAnimation(new AnimationBuilder().loop("fly2"));
        } else {
            event.getController().setAnimation(new AnimationBuilder().loop("vulture.idle"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(10.0);
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 10.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class VultureAttackGoal
    extends MeleeAttackGoal {
        public VultureAttackGoal(PathfinderMob mob, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super(mob, speedModifier, followingTargetEvenIfNotSeen);
        }

        public boolean m_8036_() {
            Player player;
            LivingEntity target = this.f_25540_.m_5448_();
            if (target instanceof Player && ((player = (Player)target).m_21223_() > 6.0f || player.m_21205_().m_41619_())) {
                return false;
            }
            return this.f_25540_.m_21205_().m_41619_() && super.m_8036_();
        }

        public boolean m_8045_() {
            Player player;
            LivingEntity target = this.f_25540_.m_5448_();
            if (target instanceof Player && ((player = (Player)target).m_21223_() > 6.0f || player.m_21205_().m_41619_())) {
                return false;
            }
            return this.f_25540_.m_21205_().m_41619_() && super.m_8045_();
        }

        protected void m_6739_(LivingEntity enemy, double distToEnemySqr) {
            double reach = this.m_6639_(enemy);
            if (distToEnemySqr <= reach && this.m_25565_() <= 0) {
                this.m_25563_();
                this.f_25540_.m_6674_(InteractionHand.MAIN_HAND);
                if (!(enemy instanceof Player)) {
                    this.f_25540_.m_7327_((Entity)enemy);
                }
                if (enemy instanceof Player && this.f_25540_.m_21205_().m_41619_() && !enemy.m_21205_().m_41619_()) {
                    this.f_25540_.m_8061_(EquipmentSlot.MAINHAND, enemy.m_21205_().m_41620_(1));
                    Level level = this.f_25540_.f_19853_;
                    level.m_6263_(null, this.f_25540_.m_20185_(), this.f_25540_.m_20186_(), this.f_25540_.m_20189_(), SoundEvents.f_12019_, SoundSource.NEUTRAL, 0.2f, ((level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
                    this.f_25540_.m_6710_(null);
                    this.f_25540_.m_21561_(false);
                }
            }
        }
    }

    static class VultureSearchForFoodGoal
    extends Goal {
        private final Vulture mob;
        private final double speedModifier;
        private final double horizontalSearchRange;
        private final double verticalSearchRange;
        private final Ingredient ingredient;

        public VultureSearchForFoodGoal(Vulture mob, double speedModifier, Ingredient ingredient, double horizontalSearchRange, double verticalSearchRange) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.mob = mob;
            this.speedModifier = speedModifier;
            this.ingredient = ingredient;
            this.horizontalSearchRange = horizontalSearchRange;
            this.verticalSearchRange = verticalSearchRange;
        }

        public boolean m_8036_() {
            if (!FOOD_ITEMS.test(this.mob.m_21205_())) {
                List list = this.mob.f_19853_.m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_(this.horizontalSearchRange, this.verticalSearchRange, this.horizontalSearchRange), itemEntity -> this.ingredient.test(itemEntity.m_32055_()));
                return !list.isEmpty() && !FOOD_ITEMS.test(this.mob.m_21205_());
            }
            return false;
        }

        public void m_8037_() {
            List list = this.mob.f_19853_.m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_(this.horizontalSearchRange, this.verticalSearchRange, this.horizontalSearchRange), itemEntity -> this.ingredient.test(itemEntity.m_32055_()));
            if (!FOOD_ITEMS.test(this.mob.m_21205_()) && !list.isEmpty()) {
                this.mob.m_21573_().m_5624_((Entity)list.get(0), this.speedModifier);
            }
        }

        public void m_8056_() {
            List list = this.mob.f_19853_.m_6443_(ItemEntity.class, this.mob.m_20191_().m_82377_(this.horizontalSearchRange, this.verticalSearchRange, this.horizontalSearchRange), itemEntity -> this.ingredient.test(itemEntity.m_32055_()));
            if (!list.isEmpty()) {
                this.mob.m_21573_().m_5624_((Entity)list.get(0), this.speedModifier);
            }
        }
    }

    static class VultureWanderGoal
    extends FlyingWanderGoal {
        public VultureWanderGoal(PathfinderMob mob) {
            super(mob);
        }

        @Override
        @Nullable
        protected Vec3 findPos() {
            Vec3 viewVector = this.mob.m_20252_(0.0f);
            return AirAndWaterRandomPos.m_148357_((PathfinderMob)this.mob, (int)12, (int)12, (int)-1, (double)viewVector.f_82479_, (double)viewVector.f_82481_, (double)Math.PI);
        }
    }

    static class VulturePathNavigation
    extends FlyingPathNavigation {
        public VulturePathNavigation(Mob mob, Level level) {
            super(mob, level);
        }

        public boolean m_6342_(BlockPos pos) {
            return super.m_6342_(pos) && this.f_26494_.f_19853_.m_8055_(pos).m_204336_(NaturalistTags.BlockTags.VULTURE_PERCH_BLOCKS);
        }
    }
}

