/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.jei.display;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.runtime.IIngredientVisibility;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.common.EffectInfo;
import net.mehvahdjukaar.jeed.plugin.jei.JEIPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;

public class EffectInfoRecipe
extends EffectInfo {
    public static final RecipeType<EffectInfoRecipe> TYPE = RecipeType.create((String)"jeed", (String)"effect_info", EffectInfoRecipe.class);

    protected EffectInfoRecipe(MobEffectInstance effectInstance, List<ItemStack> input, List<FormattedText> description) {
        super(effectInstance, input, description);
    }

    @Override
    public List<ItemStack> getInputItems() {
        IIngredientVisibility ingredientVisibility = JEIPlugin.JEI_INGREDIENT_VISIBILITY;
        return this.inputItems.stream().filter(s -> !s.m_41619_()).filter(s -> ingredientVisibility.isIngredientVisible((IIngredientType)VanillaTypes.ITEM_STACK, s)).toList();
    }

    public static List<EffectInfoRecipe> create(MobEffect effect) {
        Minecraft minecraft = Minecraft.m_91087_();
        Component text = EffectInfoRecipe.getDescription(effect);
        List<ItemStack> inputs = EffectInfoRecipe.computeEffectProviders(effect);
        int listH = EffectInfoRecipe.getListHeight(inputs);
        ArrayList<EffectInfoRecipe> recipes = new ArrayList<EffectInfoRecipe>();
        List<FormattedText> descriptionLines = EffectInfoRecipe.expandNewlines(text);
        descriptionLines = EffectInfoRecipe.wrapDescriptionLines(descriptionLines);
        int lineCount = descriptionLines.size();
        Objects.requireNonNull(minecraft.f_91062_);
        int maxLinesPerPage = (90 - listH) / (9 + 2);
        int pageCount = EffectInfoRecipe.divideCeil(lineCount, maxLinesPerPage);
        for (int i = 0; i < pageCount; ++i) {
            int startLine = i * maxLinesPerPage;
            int endLine = Math.min((i + 1) * maxLinesPerPage, lineCount);
            List<FormattedText> description = descriptionLines.subList(startLine, endLine);
            EffectInfoRecipe recipe = new EffectInfoRecipe(new MobEffectInstance(effect), inputs, description);
            recipes.add(recipe);
        }
        return recipes;
    }

    private static int divideCeil(int numerator, int denominator) {
        return (int)Math.ceil((float)numerator / (float)denominator);
    }

    private static List<FormattedText> expandNewlines(Component descriptionComponents) {
        ArrayList<FormattedText> descriptionLinesExpanded = new ArrayList<FormattedText>();
        ExpandNewLineTextAcceptor newLineTextAcceptor = new ExpandNewLineTextAcceptor();
        descriptionComponents.m_7451_((FormattedText.StyledContentConsumer)newLineTextAcceptor, Style.f_131099_);
        newLineTextAcceptor.addLinesTo(descriptionLinesExpanded);
        return descriptionLinesExpanded;
    }

    private static List<FormattedText> wrapDescriptionLines(List<FormattedText> descriptionLines) {
        Minecraft minecraft = Minecraft.m_91087_();
        ArrayList<FormattedText> descriptionLinesWrapped = new ArrayList<FormattedText>();
        for (FormattedText descriptionLine : descriptionLines) {
            List textLines = minecraft.f_91062_.m_92865_().m_92414_(descriptionLine, Jeed.PLUGIN.getMaxTextWidth(), Style.f_131099_);
            descriptionLinesWrapped.addAll(textLines);
        }
        return descriptionLinesWrapped;
    }

    private static class ExpandNewLineTextAcceptor
    implements FormattedText.StyledContentConsumer<Void> {
        private final List<FormattedText> lines = new ArrayList<FormattedText>();
        @Nullable
        private MutableComponent lastComponent;

        private ExpandNewLineTextAcceptor() {
        }

        public Optional<Void> m_7164_(Style style, String line) {
            String[] descriptionLineExpanded = line.split("\\\\n");
            for (int i = 0; i < descriptionLineExpanded.length; ++i) {
                String s = descriptionLineExpanded[i];
                if (s.isEmpty()) {
                    if (i == 0 && this.lastComponent != null) {
                        this.lines.add((FormattedText)this.lastComponent);
                        this.lastComponent = null;
                        continue;
                    }
                    this.lines.add(Component.f_130760_);
                    continue;
                }
                MutableComponent textComponent = Component.m_237113_((String)s);
                textComponent.m_6270_(style);
                if (this.lastComponent != null) {
                    if (i == 0) {
                        if (!this.lastComponent.m_7383_().m_131179_() && !this.lastComponent.m_7383_().equals((Object)style)) {
                            this.lastComponent = Component.m_237113_((String)"").m_7220_((Component)this.lastComponent);
                        }
                        this.lastComponent.m_7220_((Component)textComponent);
                        continue;
                    }
                    this.lines.add((FormattedText)this.lastComponent);
                    this.lastComponent = null;
                }
                if (i == descriptionLineExpanded.length - 1) {
                    this.lastComponent = textComponent;
                    continue;
                }
                this.lines.add((FormattedText)textComponent);
            }
            return Optional.empty();
        }

        public void addLinesTo(List<FormattedText> descriptionLinesExpanded) {
            descriptionLinesExpanded.addAll(this.lines);
            if (this.lastComponent != null) {
                descriptionLinesExpanded.add((FormattedText)this.lastComponent);
            }
        }
    }
}

