/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.jei.ingredient;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.mehvahdjukaar.jeed.plugin.jei.JEIPlugin;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;

public class EffectInstanceHelper
implements IIngredientHelper<MobEffectInstance> {
    public IIngredientType<MobEffectInstance> getIngredientType() {
        return JEIPlugin.EFFECT_INGREDIENT_TYPE;
    }

    public String getDisplayName(MobEffectInstance ingredient) {
        Component displayName = ingredient.m_19544_().m_19482_();
        return displayName.getString();
    }

    public String getUniqueId(MobEffectInstance ingredient, UidContext uidContext) {
        ResourceLocation registryName = Registry.f_122823_.m_7981_((Object)ingredient.m_19544_());
        return "effect:" + registryName;
    }

    public ResourceLocation getResourceLocation(MobEffectInstance ingredient) {
        ResourceLocation registryName = Registry.f_122823_.m_7981_((Object)ingredient.m_19544_());
        if (registryName == null) {
            String ingredientInfo = this.getErrorInfo(ingredient);
            throw new IllegalStateException("effect.getRegistryName() returned null for: " + ingredientInfo);
        }
        return registryName;
    }

    public Iterable<Integer> getColors(MobEffectInstance ingredient) {
        return Collections.singletonList(ingredient.m_19544_().m_19484_());
    }

    public ItemStack getCheatItemStack(MobEffectInstance ingredient) {
        return PotionUtils.m_43552_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), Collections.singletonList(this.normalizeIngredient(ingredient)));
    }

    public Stream<ResourceLocation> getTagStream(MobEffectInstance ingredient) {
        return Registry.f_122823_.m_7854_((Object)ingredient.m_19544_()).flatMap(arg_0 -> ((Registry)Registry.f_122823_).m_203636_(arg_0)).map(Holder::m_203616_).orElse(Stream.of(new TagKey[0])).map(TagKey::f_203868_);
    }

    public MobEffectInstance copyIngredient(MobEffectInstance ingredient) {
        return new MobEffectInstance(ingredient.m_19544_(), ingredient.m_19557_(), ingredient.m_19564_(), ingredient.m_19571_(), ingredient.m_19572_(), ingredient.m_19575_(), ingredient.f_19510_, ingredient.m_216895_());
    }

    public MobEffectInstance normalizeIngredient(MobEffectInstance ingredient) {
        return new MobEffectInstance(ingredient.m_19544_(), 600);
    }

    public String getErrorInfo(@Nullable MobEffectInstance ingredient) {
        if (ingredient == null) {
            return "null";
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(EffectInstance.class);
        MobEffect effect = ingredient.m_19544_();
        if (effect != null) {
            Component displayName = ingredient.m_19544_().m_19482_();
            toStringHelper.add("Effect", (Object)displayName.getString());
        } else {
            toStringHelper.add("Effect", (Object)"null");
        }
        toStringHelper.add("Duration", ingredient.m_19557_());
        toStringHelper.add("Amplifier", ingredient.m_19564_());
        return toStringHelper.toString();
    }
}

