/*
 * Decompiled with CFR 0.152.
 */
package ihh.potionreplacer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ihh.potionreplacer.PotionReplacer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class Config {
    private static final String DEFAULT_CONFIG = "{\"minecraft:poison\":[{\"id\":\"minecraft:poison\",\"duration\":900}],\"minecraft:long_turtle_master\":[{\"id\":\"minecraft:slowness\",\"duration\":400,\"amplifier\":3},{\"id\":\"minecraft:resistance\",\"duration\":400,\"amplifier\":2}]}";

    static Map<Potion, List<MobEffectInstance>> getEffectMap(JsonObject json) {
        HashMap<Potion, List<MobEffectInstance>> result = new HashMap<Potion, List<MobEffectInstance>>();
        for (Map.Entry entry : json.entrySet()) {
            ArrayList<MobEffectInstance> list = new ArrayList<MobEffectInstance>();
            for (JsonElement element : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                JsonObject object = element.getAsJsonObject();
                list.add(new MobEffectInstance((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(object.get("id").getAsString())), Config.getOrDefault(object, "duration", 0), Config.getOrDefault(object, "amplifier", 0)));
            }
            result.put((Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation((String)entry.getKey())), list);
        }
        return result;
    }

    static String read() {
        String string;
        File file = new File(FMLPaths.CONFIGDIR.get().toString() + File.separator + "potionreplacer.json");
        if (!file.exists()) {
            try {
                file.createNewFile();
                if (!file.exists() || file.isDirectory() || !file.canWrite()) {
                    return Config.error("Error retrieving config: The config file cannot be created or accessed!");
                }
                try (FileWriter writer = new FileWriter(file);){
                    writer.write(DEFAULT_CONFIG);
                }
                catch (IOException e) {
                    return Config.error("Error writing default config: " + e.getMessage());
                }
            }
            catch (IOException e) {
                return Config.error("Error writing default config: " + e.getMessage());
            }
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            StringBuilder builder = new StringBuilder();
            reader.lines().forEach(builder::append);
            string = builder.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return Config.error("Error reading config: " + e.getMessage());
            }
        }
        reader.close();
        return string;
    }

    private static String error(String message) {
        PotionReplacer.LOGGER.error(message);
        return DEFAULT_CONFIG;
    }

    private static int getOrDefault(JsonObject json, String key, int other) {
        try {
            return json.get(key).getAsInt();
        }
        catch (NullPointerException | NumberFormatException e) {
            return other;
        }
    }
}

