/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.core;

import agency.highlysuspect.apathy.core.Apathy;
import agency.highlysuspect.apathy.core.CoreGenOptions;
import agency.highlysuspect.apathy.core.rule.Rule;
import agency.highlysuspect.apathy.core.rule.Spec;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class JsonRule {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    @Nullable
    public static Rule loadJson(Path mobsJson) throws Exception {
        Spec<Rule, ?> spec;
        JsonElement json;
        String stuff;
        if (!Files.exists(mobsJson, new LinkOption[0])) {
            return null;
        }
        try {
            stuff = Files.lines(mobsJson).collect(Collectors.joining("\n"));
        }
        catch (Exception e) {
            throw JsonRule.context(e, "Problem loading json rule at " + mobsJson + ":");
        }
        try {
            json = (JsonElement)GSON.fromJson(stuff, JsonElement.class);
        }
        catch (Exception e) {
            throw JsonRule.context(e, "Problem parsing json rule at " + mobsJson + ":");
        }
        try {
            spec = Apathy.instance.readRule(json);
        }
        catch (Exception e) {
            throw JsonRule.context(e, "Problem decoding json rule:");
        }
        try {
            boolean debug = Apathy.instance.generalCfg.get(CoreGenOptions.debugJsonRule);
            boolean opt = Apathy.instance.generalCfg.get(CoreGenOptions.runRuleOptimizer);
            if (debug) {
                JsonRule.dump(spec, "json-rule");
            }
            if (opt) {
                spec = spec.optimize();
                if (debug) {
                    JsonRule.dump(spec, "json-rule-opt");
                }
            }
            return spec.build();
        }
        catch (Exception e) {
            throw JsonRule.context(e, "Problem finalizing rule:");
        }
    }

    public static <T extends Throwable> RuntimeException context(T in, String message) {
        RuntimeException ctx = new RuntimeException(message, in);
        ctx.setStackTrace(new StackTraceElement[0]);
        return ctx;
    }

    public static <RULE extends Spec<Rule, RULE>> void dump(Spec<Rule, RULE> ruleSpec, String filename) {
        try {
            Path dumpDir = Apathy.instance.dumpsDirPath();
            Files.createDirectories(dumpDir, new FileAttribute[0]);
            Path outPath = dumpDir.resolve(filename + ".json");
            Apathy.instance.log.info("Dumping rule to " + outPath, new Object[0]);
            JsonObject json = Apathy.instance.writeRule(ruleSpec);
            Files.write(outPath, GSON.toJson((JsonElement)json).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            Apathy.instance.log.error("Problem dumping rule to " + filename, e);
        }
    }
}

