/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.core.config;

import agency.highlysuspect.apathy.core.Apathy;
import agency.highlysuspect.apathy.core.TriState;
import agency.highlysuspect.apathy.core.rule.Who;
import agency.highlysuspect.apathy.core.wrapper.ApathyDifficulty;
import agency.highlysuspect.apathy.core.wrapper.AttackerTag;
import agency.highlysuspect.apathy.core.wrapper.AttackerType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public interface ConfigProperty<T> {
    public String name();

    public List<String> comment();

    public T defaultValue();

    public String write(T var1);

    public T parse(String var1);

    default public void validate(ConfigProperty<T> self, T thing) {
    }

    public static IntBuilder intOpt(String name, int defaultValue, String ... comment) {
        return (IntBuilder)new IntBuilder(name, defaultValue).comment(comment);
    }

    public static LongBuilder longOpt(String name, long defaultValue, String ... comment) {
        return (LongBuilder)new LongBuilder(name, defaultValue).comment(comment);
    }

    public static <B extends Builder<Boolean, B>> B boolOpt(String name, boolean defaultValue, String ... comment) {
        return (B)((Builder)((Builder)new Builder(name, defaultValue).comment(comment)).writer(x -> Boolean.toString(x))).parser(s -> Boolean.parseBoolean(s.trim()));
    }

    public static <B extends Builder<String, B>> B stringOpt(String name, String defaultValue, String ... comment) {
        return (B)((Builder)((Builder)new Builder(name, defaultValue).comment(comment)).writer(String::trim)).parser(String::trim);
    }

    public static <B extends Builder<Optional<String>, B>> B optionalStringOpt(String name, Optional<String> defaultValue, String ... comment) {
        return (B)((Builder)((Builder)new Builder(name, defaultValue).comment(comment)).writer(opt -> opt.orElse(""))).parser(s -> s.trim().isEmpty() ? Optional.empty() : Optional.of(s));
    }

    public static <B extends Builder<List<String>, B>> B stringListOpt(String name, List<String> defaultValue, String ... comment) {
        return (B)((Builder)((Builder)new Builder(name, defaultValue).comment(comment)).writer(l -> String.join((CharSequence)", ", l))).parser(s -> Arrays.stream(s.trim().split(",")).map(String::trim).collect(Collectors.toList()));
    }

    public static <B extends Builder<Set<String>, B>> B stringSetOpt(String name, Set<String> defaultValue, String ... comment) {
        return (B)((Builder)((Builder)new Builder(name, defaultValue).comment(comment)).writer(s -> s.stream().sorted().collect(Collectors.joining(", ")))).parser(s -> Arrays.stream(s.trim().split(",")).map(String::trim).collect(Collectors.toSet()));
    }

    public static <B extends Builder<Set<ApathyDifficulty>, B>> B difficultySetOpt(String name, Set<ApathyDifficulty> defaultValue, String ... comment) {
        return (B)((Builder)((Builder)new Builder(name, defaultValue).comment(comment)).writer(set -> set.stream().sorted().map(d -> d.name().toLowerCase(Locale.ROOT)).collect(Collectors.joining(", ")))).parser(s -> Arrays.stream(s.trim().split(",")).map(String::trim).map(ApathyDifficulty::fromStringOrNull).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public static <B extends Builder<TriState, B>> B allowDenyPassOpt(String name, TriState defaultValue, String ... comment) {
        return (B)((Builder)((Builder)new Builder(name, defaultValue).comment(comment)).writer(TriState::toAllowDenyPassString)).parser(s -> TriState.fromAllowDenyPassString(s.trim()));
    }

    public static <B extends Builder<Boolean, B>> B boolAllowDenyOpt(String name, boolean defaultValue, String ... comment) {
        return (B)((Builder)((Builder)new Builder(name, defaultValue).comment(comment)).writer(b -> b != false ? "allow" : "deny")).parser(s -> s.trim().equalsIgnoreCase("allow"));
    }

    public static <E extends Enum<?>, B extends Builder<E, B>> B enumOpt(String name, E defaultValue, String ... comment) {
        Class<?> enumClass = defaultValue.getClass();
        return (B)((Builder)((Builder)new Builder(name, defaultValue).comment(comment)).writer(e -> e.name().toLowerCase(Locale.ROOT))).parser(s -> {
            s = s.trim();
            for (Enum e : (Enum[])enumClass.getEnumConstants()) {
                if (!e.name().equalsIgnoreCase((String)s)) continue;
                return e;
            }
            String possibleValues = Arrays.stream((Enum[])enumClass.getEnumConstants()).map(Enum::name).collect(Collectors.joining("/"));
            Apathy.instance.log.warn("Value " + s + " on field " + name + " is not one of " + possibleValues + ". Defaulting to " + defaultValue.name().toLowerCase(Locale.ROOT), new Object[0]);
            return defaultValue;
        });
    }

    public static <B extends Builder<Set<AttackerType>, B>> B attackerTypeSetOpt(String name, Set<AttackerType> defaultValue, String ... comment) {
        return (B)((Builder)((Builder)new Builder(name, defaultValue).comment(comment)).writer(set -> set.stream().map(AttackerType::apathy$id).collect(Collectors.joining(", ")))).parser(s -> Arrays.stream(s.trim().split(",")).map(String::trim).map(Apathy.instance::parseAttackerType).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public static <B extends Builder<Set<AttackerTag>, B>> B attackerTagSetOpt(String name, Set<AttackerTag> defaultValue, String ... comment) {
        return (B)((Builder)((Builder)new Builder(name, defaultValue).comment(comment)).writer(set -> set.stream().map(AttackerTag::apathy$id).collect(Collectors.joining(", ")))).parser(s -> Arrays.stream(s.trim().split(",")).map(String::trim).map(Apathy.instance::parseAttackerTag).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public static <B extends Builder<Who, B>> B whoOpt(String name, Who defaultValue, String ... comment) {
        return (B)((Builder)((Builder)new Builder(name, defaultValue).comment(comment)).writer(Who::toString)).parser(Who::fromString);
    }

    public static class IntBuilder
    extends Builder<Integer, IntBuilder> {
        public IntBuilder(String name, Integer defaultValue) {
            super(name, defaultValue);
            this.writer(x -> Integer.toString(x));
            this.parser(s -> Integer.parseInt(s.trim()));
        }

        public IntBuilder atLeast(int min) {
            return (IntBuilder)this.addValidator((self, x) -> {
                if (x < min) {
                    throw new IllegalArgumentException("Expected value of " + self.name() + " to be at least " + min + ".");
                }
            });
        }

        public IntBuilder atMost(int max) {
            return (IntBuilder)this.addValidator((self, x) -> {
                if (x > max) {
                    throw new IllegalArgumentException("Expected value of " + self.name() + " to be at most " + max + ".");
                }
            });
        }
    }

    public static class Builder<T, BUILDER extends Builder<T, BUILDER>> {
        private final String name;
        private List<String> comment = null;
        private final T defaultValue;
        @Nullable
        private Function<T, String> writer;
        @Nullable
        private Function<String, T> parser;
        @Nullable
        private BiConsumer<ConfigProperty<T>, T> validator = null;

        public Builder(String name, T defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public BUILDER comment(String ... comment) {
            if (this.comment == null) {
                this.comment = new ArrayList<String>(4);
            }
            this.comment.addAll(Arrays.asList(comment));
            return this.self();
        }

        public BUILDER note(String ... note) {
            boolean first = true;
            for (String noteLine : note) {
                this.comment((first ? "Note: " : "     ") + noteLine);
                first = false;
            }
            return this.self();
        }

        public BUILDER example(String example) {
            this.comment("Example: " + example);
            return this.self();
        }

        public BUILDER writer(Function<T, String> writer) {
            this.writer = writer;
            return this.self();
        }

        public BUILDER parser(Function<String, T> parser) {
            this.parser = parser;
            return this.self();
        }

        public BUILDER addValidator(BiConsumer<ConfigProperty<T>, T> validator) {
            this.validator = this.validator == null ? validator : this.validator.andThen(validator);
            return this.self();
        }

        public ConfigProperty<T> build() {
            if (this.writer == null || this.parser == null) {
                throw new IllegalStateException("missing writer/parser");
            }
            return new ConfigProperty<T>(){

                @Override
                public String name() {
                    return name;
                }

                @Override
                public List<String> comment() {
                    return comment == null ? Collections.emptyList() : comment;
                }

                @Override
                public T defaultValue() {
                    return defaultValue;
                }

                @Override
                public String write(T thing) {
                    return writer.apply(thing);
                }

                @Override
                public T parse(String s) {
                    return parser.apply(s);
                }

                @Override
                public void validate(ConfigProperty<T> self, T thing) {
                    if (validator != null) {
                        validator.accept((ConfigProperty)self, (ConfigProperty)thing);
                    }
                }
            };
        }

        protected BUILDER self() {
            return (BUILDER)this;
        }
    }

    public static class LongBuilder
    extends Builder<Long, LongBuilder> {
        public LongBuilder(String name, Long defaultValue) {
            super(name, defaultValue);
            this.writer(l -> Long.toString(l));
            this.parser(s -> Long.parseLong(s.trim()));
        }

        public LongBuilder atLeast(long min) {
            return (LongBuilder)this.addValidator((self, x) -> {
                if (x < min) {
                    throw new IllegalArgumentException("Expected value of " + self.name() + " to be at least " + min + ".");
                }
            });
        }

        public LongBuilder atMost(long max) {
            return (LongBuilder)this.addValidator((self, x) -> {
                if (x > max) {
                    throw new IllegalArgumentException("Expected value of " + self.name() + " to be at most " + max + ".");
                }
            });
        }
    }
}

