/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.core.config;

import agency.highlysuspect.apathy.core.config.ConfigProperty;
import agency.highlysuspect.apathy.core.config.CookedConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ConfigSchema {
    private Map<String, List<ConfigProperty<?>>> entries = new LinkedHashMap();
    private static final String SECTIONLESS = "\ud83d\udc09";
    private String currentSection = "\ud83d\udc09";

    public void section(String sectionName) {
        this.currentSection = sectionName == null ? SECTIONLESS : sectionName;
    }

    public void option(ConfigProperty<?> ... options) {
        this.getSection(this.currentSection).addAll(Arrays.asList(options));
    }

    public void section(String sectionName, ConfigProperty<?> ... options) {
        this.section(sectionName);
        this.option(options);
    }

    public void afterSection(String hook, String sectionName, ConfigProperty<?> ... options) {
        LinkedHashMap copy = new LinkedHashMap();
        boolean addedAny = false;
        for (Map.Entry<String, List<ConfigProperty<?>>> entry : this.entries.entrySet()) {
            copy.put(entry.getKey(), entry.getValue());
            if (!entry.getKey().equals(hook)) continue;
            addedAny = true;
            copy.put(sectionName, Arrays.asList(options));
        }
        if (!addedAny) {
            throw new IllegalArgumentException("couldn't find a section named " + hook);
        }
        this.entries = copy;
    }

    public List<ConfigProperty<?>> getSection(String name) {
        return this.entries.computeIfAbsent(name, __ -> new ArrayList());
    }

    public void accept(Visitor visitor) {
        this.entries.forEach((section, options) -> {
            if (!SECTIONLESS.equals(section)) {
                visitor.visitSection((String)section);
            }
            options.forEach(visitor::visitOption);
        });
    }

    public Map<String, ConfigProperty<?>> propertiesByName() {
        final LinkedHashMap props = new LinkedHashMap();
        this.accept(new Visitor(){

            @Override
            public <T> void visitOption(ConfigProperty<T> option) {
                props.put(option.name(), option);
            }
        });
        return props;
    }

    public static interface Visitor {
        default public void visitSection(String section) {
        }

        default public <T> void visitOption(ConfigProperty<T> option) {
        }
    }

    public static interface Bakery {
        public CookedConfig cook(ConfigSchema var1);
    }
}

