/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.core.rule;

import agency.highlysuspect.apathy.core.Apathy;
import agency.highlysuspect.apathy.core.rule.CoolGsonHelper;
import agency.highlysuspect.apathy.core.rule.JsonSerializer;
import agency.highlysuspect.apathy.core.rule.Partial;
import agency.highlysuspect.apathy.core.rule.PartialSpecAlways;
import agency.highlysuspect.apathy.core.rule.Spec;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class PartialSpecAny
implements Spec<Partial, PartialSpecAny> {
    public final Set<Spec<Partial, ?>> others;

    public PartialSpecAny(Set<Spec<Partial, ?>> others) {
        this.others = others;
    }

    @Override
    public Spec<Partial, ?> optimize() {
        Set<Spec<Partial, ?>> loweredSpecs = this.others.stream().map(Spec::optimize).collect(Collectors.toSet());
        if (loweredSpecs.stream().anyMatch(pred -> pred == PartialSpecAlways.TRUE)) {
            return PartialSpecAlways.TRUE;
        }
        loweredSpecs.removeIf(pred -> pred == PartialSpecAlways.FALSE);
        if (loweredSpecs.size() == 0) {
            return PartialSpecAlways.FALSE;
        }
        if (loweredSpecs.size() == 1) {
            return (Spec)loweredSpecs.iterator().next();
        }
        return new PartialSpecAny(loweredSpecs);
    }

    @Override
    public Partial build() {
        Partial[] arrayParts = (Partial[])this.others.stream().map(Spec::build).toArray(Partial[]::new);
        return (attacker, defender) -> {
            for (Partial p : arrayParts) {
                if (!p.test(attacker, defender)) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    public JsonSerializer<PartialSpecAny> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements JsonSerializer<PartialSpecAny> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void write(PartialSpecAny thing, JsonObject json) {
            json.add("predicates", (JsonElement)thing.others.stream().map(Apathy.instance::writePartial).collect(CoolGsonHelper.toJsonArray()));
        }

        @Override
        public PartialSpecAny read(JsonObject json) {
            HashSet partials = new HashSet();
            JsonArray partialsArray = json.getAsJsonArray("predicates");
            for (JsonElement e : partialsArray) {
                partials.add(Apathy.instance.readPartial(e));
            }
            return new PartialSpecAny(partials);
        }
    }
}

