/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.core.rule;

import agency.highlysuspect.apathy.core.rule.JsonSerializer;
import agency.highlysuspect.apathy.core.rule.Partial;
import agency.highlysuspect.apathy.core.rule.PartialSpecAlways;
import agency.highlysuspect.apathy.core.rule.Spec;
import com.google.gson.JsonObject;
import java.util.Random;

public class PartialSpecRandom
implements Spec<Partial, PartialSpecRandom> {
    private final double chance;

    public PartialSpecRandom(double chance) {
        this.chance = chance;
    }

    @Override
    public Spec<Partial, ?> optimize() {
        if (this.chance == 0.0) {
            return PartialSpecAlways.FALSE;
        }
        if (this.chance == 1.0) {
            return PartialSpecAlways.TRUE;
        }
        return this;
    }

    @Override
    public Partial build() {
        return (attacker, defender) -> (double)new Random(attacker.apathy$uuidBits()).nextFloat() <= this.chance;
    }

    @Override
    public JsonSerializer<PartialSpecRandom> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements JsonSerializer<PartialSpecRandom> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void write(PartialSpecRandom thing, JsonObject json) {
            json.addProperty("chance", (Number)thing.chance);
        }

        @Override
        public PartialSpecRandom read(JsonObject json) {
            return new PartialSpecRandom(json.get("chance").getAsDouble());
        }
    }
}

