/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.core.rule;

import agency.highlysuspect.apathy.core.rule.JsonSerializer;
import agency.highlysuspect.apathy.core.rule.Partial;
import agency.highlysuspect.apathy.core.rule.PartialSpecAlways;
import agency.highlysuspect.apathy.core.rule.Spec;
import com.google.gson.JsonObject;

public final class PartialSpecRevengeTimer
implements Spec<Partial, PartialSpecRevengeTimer> {
    private final long timeout;

    public PartialSpecRevengeTimer(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public Spec<Partial, ?> optimize() {
        if (this.timeout <= 0L) {
            return PartialSpecAlways.FALSE;
        }
        return this;
    }

    @Override
    public Partial build() {
        return (attacker, defender) -> {
            long provocationTime = attacker.apathy$getProvocationTime();
            return provocationTime != Long.MIN_VALUE && attacker.apathy$now() - provocationTime <= this.timeout;
        };
    }

    @Override
    public JsonSerializer<PartialSpecRevengeTimer> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements JsonSerializer<PartialSpecRevengeTimer> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void write(PartialSpecRevengeTimer thing, JsonObject json) {
            json.addProperty("timeout", (Number)thing.timeout);
        }

        @Override
        public PartialSpecRevengeTimer read(JsonObject json) {
            return new PartialSpecRevengeTimer(json.getAsJsonPrimitive("timeout").getAsLong());
        }
    }
}

