/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.core.rule;

import agency.highlysuspect.apathy.core.TriState;
import agency.highlysuspect.apathy.core.rule.CoolGsonHelper;
import agency.highlysuspect.apathy.core.rule.JsonSerializer;
import agency.highlysuspect.apathy.core.rule.Rule;
import agency.highlysuspect.apathy.core.rule.Spec;
import com.google.gson.JsonObject;

public class RuleSpecAlways
implements Spec<Rule, RuleSpecAlways> {
    public final TriState value;
    public static final RuleSpecAlways ALWAYS_ALLOW = new RuleSpecAlways(TriState.TRUE);
    public static final RuleSpecAlways ALWAYS_DENY = new RuleSpecAlways(TriState.FALSE);
    public static final RuleSpecAlways ALWAYS_PASS = new RuleSpecAlways(TriState.DEFAULT);

    private RuleSpecAlways(TriState value) {
        this.value = value;
    }

    public static RuleSpecAlways get(TriState which) {
        switch (which) {
            case FALSE: {
                return ALWAYS_DENY;
            }
            case DEFAULT: {
                return ALWAYS_PASS;
            }
            case TRUE: {
                return ALWAYS_ALLOW;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Rule build() {
        return (attacker, defender) -> this.value;
    }

    @Override
    public JsonSerializer<RuleSpecAlways> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements JsonSerializer<RuleSpecAlways> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void write(RuleSpecAlways thing, JsonObject json) {
            json.addProperty("value", thing.value.toAllowDenyPassString());
        }

        @Override
        public RuleSpecAlways read(JsonObject json) {
            return RuleSpecAlways.get(CoolGsonHelper.getAllowDenyPassTriState(json, "value"));
        }
    }
}

