/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.core.rule;

import agency.highlysuspect.apathy.core.Apathy;
import agency.highlysuspect.apathy.core.TriState;
import agency.highlysuspect.apathy.core.rule.JsonSerializer;
import agency.highlysuspect.apathy.core.rule.Rule;
import agency.highlysuspect.apathy.core.rule.RuleSpecAlways;
import agency.highlysuspect.apathy.core.rule.Spec;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RuleSpecChain
implements Spec<Rule, RuleSpecChain> {
    public final List<Spec<Rule, ?>> rules;

    public RuleSpecChain(List<Spec<Rule, ?>> rules) {
        this.rules = rules;
    }

    @Override
    public Spec<Rule, ?> optimize() {
        List optimizedRules = this.rules.stream().map(Spec::optimize).collect(Collectors.toList());
        if (optimizedRules.size() == 0) {
            return RuleSpecAlways.ALWAYS_PASS;
        }
        if (optimizedRules.size() == 1) {
            return (Spec)optimizedRules.get(0);
        }
        if (optimizedRules.get(0) == RuleSpecAlways.ALWAYS_ALLOW) {
            return RuleSpecAlways.ALWAYS_ALLOW;
        }
        if (optimizedRules.get(0) == RuleSpecAlways.ALWAYS_DENY) {
            return RuleSpecAlways.ALWAYS_DENY;
        }
        ArrayList filteredRules = new ArrayList();
        for (Spec spec : optimizedRules) {
            if (spec == RuleSpecAlways.ALWAYS_PASS) continue;
            filteredRules.add(spec);
            if (spec != RuleSpecAlways.ALWAYS_ALLOW && spec != RuleSpecAlways.ALWAYS_DENY) continue;
            break;
        }
        if (filteredRules.size() == 0) {
            return RuleSpecAlways.ALWAYS_PASS;
        }
        if (filteredRules.size() == 1) {
            return (Spec)filteredRules.get(0);
        }
        return new RuleSpecChain(filteredRules);
    }

    @Override
    public Rule build() {
        Rule[] built = (Rule[])this.rules.stream().map(Spec::build).toArray(Rule[]::new);
        return (attacker, defender) -> {
            for (Rule rule : built) {
                TriState result = (TriState)((Object)((Object)rule.apply(attacker, defender)));
                if (result == TriState.DEFAULT) continue;
                return result;
            }
            return TriState.DEFAULT;
        };
    }

    @Override
    public JsonSerializer<RuleSpecChain> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements JsonSerializer<RuleSpecChain> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void write(RuleSpecChain thing, JsonObject json) {
            JsonArray rulesArray = new JsonArray();
            for (Spec<Rule, ?> ruleToWrite : thing.rules) {
                rulesArray.add((JsonElement)Apathy.instance.writeRule(ruleToWrite));
            }
            json.add("rules", (JsonElement)rulesArray);
        }

        @Override
        public RuleSpecChain read(JsonObject json) {
            JsonArray rulesArray = json.getAsJsonArray("rules");
            ArrayList rules = new ArrayList();
            for (JsonElement e : rulesArray) {
                rules.add(Apathy.instance.readRule((JsonElement)e.getAsJsonObject()));
            }
            return new RuleSpecChain(rules);
        }
    }
}

