/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.core.rule;

import agency.highlysuspect.apathy.core.Apathy;
import agency.highlysuspect.apathy.core.TriState;
import agency.highlysuspect.apathy.core.rule.CoolGsonHelper;
import agency.highlysuspect.apathy.core.rule.JsonSerializer;
import agency.highlysuspect.apathy.core.rule.Rule;
import agency.highlysuspect.apathy.core.rule.RuleSpecAlways;
import agency.highlysuspect.apathy.core.rule.Spec;
import agency.highlysuspect.apathy.core.wrapper.ApathyDifficulty;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class RuleSpecDifficultyCase
implements Spec<Rule, RuleSpecDifficultyCase> {
    public final Map<ApathyDifficulty, Spec<Rule, ?>> ruleSpecs;
    private static final Rule alwaysPasses = RuleSpecAlways.ALWAYS_PASS.build();

    public RuleSpecDifficultyCase(Map<ApathyDifficulty, Spec<Rule, ?>> ruleSpecs) {
        this.ruleSpecs = ruleSpecs;
    }

    @Override
    public Spec<Rule, ?> optimize() {
        return new RuleSpecDifficultyCase(this.ruleSpecs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, p -> ((Spec)p.getValue()).optimize())));
    }

    @Override
    public Rule build() {
        EnumMap built = new EnumMap(ApathyDifficulty.class);
        this.ruleSpecs.forEach((difficulty, ruleSpec) -> built.put((ApathyDifficulty)((Object)difficulty), (Rule)ruleSpec.build()));
        return (attacker, defender) -> (TriState)((Object)((Object)built.getOrDefault((Object)attacker.apathy$getDifficulty(), alwaysPasses).apply(attacker, defender)));
    }

    @Override
    public JsonSerializer<RuleSpecDifficultyCase> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements JsonSerializer<RuleSpecDifficultyCase> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void write(RuleSpecDifficultyCase thing, JsonObject json) {
            JsonObject cases = new JsonObject();
            thing.ruleSpecs.forEach((difficulty, diffRule) -> cases.add(difficulty.toString(), (JsonElement)Apathy.instance.writeRule(diffRule)));
            json.add("cases", (JsonElement)cases);
        }

        @Override
        public RuleSpecDifficultyCase read(JsonObject json) {
            HashMap ruleSpecs = new HashMap();
            JsonObject cases = json.getAsJsonObject("cases");
            for (String key : CoolGsonHelper.keySet(cases)) {
                ApathyDifficulty diff = ApathyDifficulty.fromStringOrNull(key);
                if (diff == null) continue;
                ruleSpecs.put(diff, Apathy.instance.readRule((JsonElement)cases.getAsJsonObject(key)));
            }
            return new RuleSpecDifficultyCase(ruleSpecs);
        }
    }
}

