/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.core.rule;

import agency.highlysuspect.apathy.core.Apathy;
import agency.highlysuspect.apathy.core.TriState;
import agency.highlysuspect.apathy.core.rule.JsonSerializer;
import agency.highlysuspect.apathy.core.rule.Partial;
import agency.highlysuspect.apathy.core.rule.PartialSpecAlways;
import agency.highlysuspect.apathy.core.rule.Rule;
import agency.highlysuspect.apathy.core.rule.RuleSpecAlways;
import agency.highlysuspect.apathy.core.rule.Spec;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class RuleSpecIf
implements Spec<Rule, RuleSpecIf> {
    private final Spec<Rule, ?> ifTrue;
    private final Spec<Rule, ?> ifFalse;
    private final Spec<Partial, ?> predicate;

    public RuleSpecIf(Spec<Rule, ?> ifTrue, Spec<Rule, ?> ifFalse, Spec<Partial, ?> predicate) {
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
        this.predicate = predicate;
    }

    @Override
    public Spec<Rule, ?> optimize() {
        Spec<Rule, ?> ifTrue = this.ifTrue.optimize();
        Spec<Rule, ?> ifFalse = this.ifFalse.optimize();
        Spec<Partial, ?> predicate = this.predicate.optimize();
        if (predicate == PartialSpecAlways.TRUE) {
            return ifTrue;
        }
        if (predicate == PartialSpecAlways.FALSE) {
            return ifFalse;
        }
        if (ifTrue == ifFalse) {
            return ifTrue;
        }
        return new RuleSpecIf(ifTrue, ifFalse, predicate);
    }

    @Override
    public Rule build() {
        Partial condition = this.predicate.build();
        Rule ifTrue = this.ifTrue.build();
        Rule ifFalse = this.ifFalse.build();
        return (attacker, defender) -> condition.test(attacker, defender) ? (TriState)((Object)((Object)ifTrue.apply(attacker, defender))) : (TriState)((Object)((Object)ifFalse.apply(attacker, defender)));
    }

    @Override
    public JsonSerializer<RuleSpecIf> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements JsonSerializer<RuleSpecIf> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void write(RuleSpecIf thing, JsonObject json) {
            json.add("if_true", (JsonElement)Apathy.instance.writeRule(thing.ifTrue));
            json.add("if_false", (JsonElement)Apathy.instance.writeRule(thing.ifFalse));
            json.add("predicate", (JsonElement)Apathy.instance.writePartial(thing.predicate));
        }

        @Override
        public RuleSpecIf read(JsonObject json) {
            RuleSpecAlways ifTrue = json.has("if_true") ? Apathy.instance.readRule(json.get("if_true")) : RuleSpecAlways.ALWAYS_PASS;
            RuleSpecAlways ifFalse = json.has("if_false") ? Apathy.instance.readRule(json.get("if_false")) : RuleSpecAlways.ALWAYS_PASS;
            Spec<Partial, ?> predicate = Apathy.instance.readPartial(json.get("predicate"));
            return new RuleSpecIf(ifTrue, ifFalse, predicate);
        }
    }
}

