/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.core.rule;

import agency.highlysuspect.apathy.core.Apathy;
import agency.highlysuspect.apathy.core.TriState;
import agency.highlysuspect.apathy.core.rule.CoolGsonHelper;
import agency.highlysuspect.apathy.core.rule.JsonSerializer;
import agency.highlysuspect.apathy.core.rule.Partial;
import agency.highlysuspect.apathy.core.rule.PartialSpecAlways;
import agency.highlysuspect.apathy.core.rule.Rule;
import agency.highlysuspect.apathy.core.rule.RuleSpecAlways;
import agency.highlysuspect.apathy.core.rule.Spec;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public final class RuleSpecPredicated
implements Spec<Rule, RuleSpecPredicated> {
    private final TriState ifTrue;
    private final TriState ifFalse;
    private final Spec<Partial, ?> predSpec;

    public RuleSpecPredicated(TriState ifTrue, TriState ifFalse, Spec<Partial, ?> predSpec) {
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
        this.predSpec = predSpec;
    }

    @Override
    public Spec<Rule, ?> optimize() {
        if (this.ifTrue == this.ifFalse) {
            return RuleSpecAlways.get(this.ifTrue);
        }
        Spec<Partial, ?> predSpecOpt = this.predSpec.optimize();
        if (predSpecOpt == PartialSpecAlways.TRUE) {
            return RuleSpecAlways.get(this.ifTrue);
        }
        if (predSpecOpt == PartialSpecAlways.FALSE) {
            return RuleSpecAlways.get(this.ifFalse);
        }
        return new RuleSpecPredicated(this.ifTrue, this.ifFalse, predSpecOpt);
    }

    @Override
    public Rule build() {
        Partial builtPred = this.predSpec.build();
        return (attacker, defender) -> builtPred.test(attacker, defender) ? this.ifTrue : this.ifFalse;
    }

    @Override
    public JsonSerializer<RuleSpecPredicated> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements JsonSerializer<RuleSpecPredicated> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void write(RuleSpecPredicated thing, JsonObject json) {
            json.addProperty("if_true", thing.ifTrue.toAllowDenyPassString());
            json.addProperty("if_false", thing.ifFalse.toAllowDenyPassString());
            json.add("predicate", (JsonElement)Apathy.instance.writePartial(thing.predSpec));
        }

        @Override
        public RuleSpecPredicated read(JsonObject json) {
            TriState ifTrue = CoolGsonHelper.getAllowDenyPassTriState(json, "if_true", TriState.DEFAULT);
            TriState ifFalse = CoolGsonHelper.getAllowDenyPassTriState(json, "if_false", TriState.DEFAULT);
            Spec<Partial, ?> part = Apathy.instance.readPartial(json.get("predicate"));
            return new RuleSpecPredicated(ifTrue, ifFalse, part);
        }
    }

    @Deprecated
    public static class LegacyDenyIfSerializer
    implements JsonSerializer<RuleSpecPredicated> {
        public static final LegacyDenyIfSerializer INSTANCE = new LegacyDenyIfSerializer();

        private LegacyDenyIfSerializer() {
        }

        @Override
        public void write(RuleSpecPredicated thing, JsonObject json) {
            json.add("predicate", (JsonElement)Apathy.instance.writePartial(thing.predSpec));
        }

        @Override
        public RuleSpecPredicated read(JsonObject json) {
            return new RuleSpecPredicated(TriState.FALSE, TriState.DEFAULT, Apathy.instance.readPartial(json.get("predicate")));
        }
    }

    @Deprecated
    public static class LegacyAllowIfSerializer
    implements JsonSerializer<RuleSpecPredicated> {
        public static final LegacyAllowIfSerializer INSTANCE = new LegacyAllowIfSerializer();

        private LegacyAllowIfSerializer() {
        }

        @Override
        public void write(RuleSpecPredicated thing, JsonObject json) {
            json.add("predicate", (JsonElement)Apathy.instance.writePartial(thing.predSpec));
        }

        @Override
        public RuleSpecPredicated read(JsonObject json) {
            return new RuleSpecPredicated(TriState.TRUE, TriState.DEFAULT, Apathy.instance.readPartial(json.get("predicate")));
        }
    }
}

