/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.coreplusminecraft.rule;

import agency.highlysuspect.apathy.core.rule.CoolGsonHelper;
import agency.highlysuspect.apathy.core.rule.JsonSerializer;
import agency.highlysuspect.apathy.core.rule.Partial;
import agency.highlysuspect.apathy.core.rule.Spec;
import agency.highlysuspect.apathy.coreplusminecraft.MinecraftConv;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.scores.PlayerTeam;

public class PartialSpecScoreboardTeam
implements Spec<Partial, PartialSpecScoreboardTeam> {
    private final Set<String> teamNames;

    public PartialSpecScoreboardTeam(Set<String> teamNames) {
        this.teamNames = teamNames;
    }

    @Override
    public Partial build() {
        return (attacker, defender) -> {
            ServerLevel level = MinecraftConv.level(defender);
            ServerScoreboard scoreboard = level.m_6188_();
            PlayerTeam team = scoreboard.m_83500_(defender.apathy$scoreboardName());
            return team != null && this.teamNames.contains(team.m_5758_());
        };
    }

    @Override
    public JsonSerializer<PartialSpecScoreboardTeam> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements JsonSerializer<PartialSpecScoreboardTeam> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void write(PartialSpecScoreboardTeam thing, JsonObject json) {
            json.add("teams", (JsonElement)thing.teamNames.stream().map(JsonPrimitive::new).collect(CoolGsonHelper.toJsonArray()));
        }

        @Override
        public PartialSpecScoreboardTeam read(JsonObject json) {
            if (json.has("team")) {
                return new PartialSpecScoreboardTeam(Collections.singleton(json.getAsJsonPrimitive("teams").getAsString()));
            }
            return new PartialSpecScoreboardTeam(CoolGsonHelper.streamArray(json.getAsJsonArray("teams")).map(JsonElement::getAsString).collect(Collectors.toSet()));
        }
    }
}

