/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.apathy.platform.forge;

import agency.highlysuspect.apathy.core.Apathy;
import agency.highlysuspect.apathy.core.config.ConfigProperty;
import agency.highlysuspect.apathy.core.config.ConfigSchema;
import agency.highlysuspect.apathy.core.config.CookedConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeBackedConfig
implements CookedConfig {
    private final Map<ConfigProperty<?>, Supplier<?>> liveConfig;
    private final Map<ConfigProperty<?>, Object> cache = new IdentityHashMap();

    public ForgeBackedConfig(Map<ConfigProperty<?>, Supplier<?>> liveConfig) {
        this.liveConfig = liveConfig;
    }

    @Override
    public <T> T get(ConfigProperty<T> key) {
        return (T)this.cache.computeIfAbsent(key, this::getUncached);
    }

    private <T> T getUncached(ConfigProperty<T> key) {
        Supplier<?> s = this.liveConfig.get(key);
        if (s == null) {
            return key.defaultValue();
        }
        try {
            return (T)s.get();
        }
        catch (Exception e) {
            Apathy.instance.log.error("Failed to parse option '" + key.name() + "': " + e.getMessage() + ". Using default value.", e);
            return key.defaultValue();
        }
    }

    @Override
    public boolean refresh() {
        this.cache.clear();
        return true;
    }

    public static class Bakery
    implements ConfigSchema.Bakery {
        public final ForgeConfigSpec.Builder spec;

        public Bakery(ForgeConfigSpec.Builder spec) {
            this.spec = spec;
        }

        @Override
        public CookedConfig cook(ConfigSchema schema) {
            final IdentityHashMap configGetters = new IdentityHashMap();
            this.spec.push("Uncategorized");
            schema.accept(new ConfigSchema.Visitor(){

                @Override
                public void visitSection(String section) {
                    spec.pop();
                    spec.push(section);
                }

                @Override
                public <T> void visitOption(ConfigProperty<T> option) {
                    List<String> comment = option.comment();
                    if (comment.isEmpty()) {
                        spec.comment(" ");
                    } else {
                        ArrayList<Object> commentWithDefault = new ArrayList<Object>(comment.size() + 1);
                        commentWithDefault.addAll(comment);
                        commentWithDefault.add("Default: " + option.write(option.defaultValue()));
                        spec.comment((String[])commentWithDefault.toArray(String[]::new));
                    }
                    T hmm = option.defaultValue();
                    if (hmm instanceof Boolean && !option.name().equals("fallthrough")) {
                        ForgeConfigSpec.BooleanValue forge = spec.define(option.name(), ((Boolean)hmm).booleanValue());
                        configGetters.put(option, () -> {
                            Object what = forge.get();
                            String stringified = what.toString();
                            boolean real = Boolean.parseBoolean(stringified);
                            option.validate(option, real);
                            return real;
                        });
                    } else if (hmm instanceof Long) {
                        ForgeConfigSpec.LongValue forge = spec.defineInRange(option.name(), ((Long)hmm).longValue(), Long.MIN_VALUE, Long.MAX_VALUE);
                        configGetters.put(option, () -> {
                            Object what = forge.get();
                            String stringified = what.toString();
                            long real = Long.parseLong(stringified);
                            option.validate(option, real);
                            return real;
                        });
                    } else if (hmm instanceof Integer) {
                        ForgeConfigSpec.IntValue forge = spec.defineInRange(option.name(), ((Integer)hmm).intValue(), Integer.MIN_VALUE, Integer.MAX_VALUE);
                        configGetters.put(option, () -> {
                            Object what = forge.get();
                            String stringified = what.toString();
                            int real = Integer.parseInt(stringified);
                            option.validate(option, real);
                            return real;
                        });
                    } else if (hmm instanceof String) {
                        ForgeConfigSpec.ConfigValue forge = spec.define(option.name(), (Object)((String)hmm));
                        configGetters.put(option, () -> {
                            String s = (String)forge.get();
                            option.validate(option, s);
                            return s;
                        });
                    } else {
                        ForgeConfigSpec.ConfigValue forge = spec.define(Collections.singletonList(option.name()), () -> option.write(option.defaultValue()), thing -> {
                            try {
                                Object thingParsed = option.parse(thing.toString());
                                option.validate(option, thingParsed);
                                return true;
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }, String.class);
                        configGetters.put(option, () -> option.parse((String)forge.get()));
                    }
                }
            });
            return new ForgeBackedConfig(configGetters);
        }
    }
}

