/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.capabilities;

import java.util.Objects;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import pepjebs.mapatlases.utils.MapType;
import pepjebs.mapatlases.utils.Slice;

public record MapKey(int mapX, int mapZ, Slice slice) {
    public boolean isSameSlice(Slice slice) {
        return Objects.equals(slice, this.slice);
    }

    public static MapKey at(byte scale, double px, double pz, Slice slice) {
        int i = 128 * (1 << scale);
        ColumnPos center = slice.type().getCenter(px, pz, i);
        return new MapKey(center.f_140723_(), center.f_140724_(), slice);
    }

    public static MapKey at(byte scale, Player player, Integer slice) {
        return MapKey.at(scale, player, Slice.of(MapType.VANILLA, slice, (ResourceKey<Level>)player.f_19853_.m_46472_()));
    }

    public static MapKey at(byte scale, Player player, Slice slice) {
        double px = player.m_20185_();
        double pz = player.m_20189_();
        return MapKey.at(scale, px, pz, slice);
    }
}

