/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.capabilities.MapKey;
import pepjebs.mapatlases.client.forge.MapAtlasesClientImpl;
import pepjebs.mapatlases.client.screen.AtlasOverviewScreen;
import pepjebs.mapatlases.config.MapAtlasesClientConfig;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.map_collection.IMapCollection;
import pepjebs.mapatlases.mixin.MapItemSavedDataAccessor;
import pepjebs.mapatlases.networking.S2CMapPacketWrapper;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;
import pepjebs.mapatlases.utils.MapDataHolder;
import pepjebs.mapatlases.utils.Slice;

public class MapAtlasesClient {
    public static final Material OVERWORLD_TEXTURE = new Material(InventoryMenu.f_39692_, MapAtlasesMod.res("entity/lectern_atlas"));
    public static final Material NETHER_TEXTURE = new Material(InventoryMenu.f_39692_, MapAtlasesMod.res("entity/lectern_atlas_nether"));
    public static final Material END_TEXTURE = new Material(InventoryMenu.f_39692_, MapAtlasesMod.res("entity/lectern_atlas_end"));
    public static final Material OTHER_TEXTURE = new Material(InventoryMenu.f_39692_, MapAtlasesMod.res("entity/lectern_atlas_unknown"));
    public static final List<String> DIMENSION_TEXTURE_ORDER = List.of(Level.f_46428_.m_135782_().toString(), Level.f_46429_.m_135782_().toString(), Level.f_46430_.m_135782_().toString(), "aether:the_aether", "twilightforest:twilight_forest", "undergarden:undergarden", "tropicraft:tropics", "thebetweenlands:betweenlands", "blue_skies:everbright", "the_bumblezone:the_bumblezone");
    public static final KeyMapping OPEN_ATLAS_KEYBIND = new KeyMapping("key.map_atlases.open_minimap", InputConstants.Type.KEYSYM, 77, "category.map_atlases.minimap");
    public static final KeyMapping INCREASE_MINIMAP_ZOOM = new KeyMapping("key.map_atlases.zoom_in_minimap", InputConstants.Type.KEYSYM, 334, "category.map_atlases.minimap");
    public static final KeyMapping DECREASE_MINIMAP_ZOOM = new KeyMapping("key.map_atlases.zoom_out_minimap", InputConstants.Type.KEYSYM, 333, "category.map_atlases.minimap");
    public static final KeyMapping INCREASE_SLICE = new KeyMapping("key.map_atlases.increase_slice", InputConstants.f_84822_.m_84873_(), "category.map_atlases.minimap");
    public static final KeyMapping DECREASE_SLICE = new KeyMapping("key.map_atlases.decrease_slice", InputConstants.f_84822_.m_84873_(), "category.map_atlases.minimap");
    private static final ThreadLocal<Float> globalDecorationScale = ThreadLocal.withInitial(() -> Float.valueOf(1.0f));
    private static final ThreadLocal<Float> globalDecorationRotation = ThreadLocal.withInitial(() -> Float.valueOf(0.0f));
    @Nullable
    private static MapKey currentActiveMapKey = null;
    private static MapDataHolder currentActiveMap = null;
    private static ItemStack currentActiveAtlas = ItemStack.f_41583_;
    private static boolean isDrawingAtlas = false;
    private static final Cache<String, Integer> CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(10L, TimeUnit.SECONDS).build();

    public static void cachePlayerState(Player player) {
        ItemStack atlas;
        if (player != Minecraft.m_91087_().f_91074_) {
            return;
        }
        currentActiveAtlas = atlas = MapAtlasesAccessUtils.getAtlasFromPlayerByConfig(player);
        currentActiveMap = null;
        currentActiveMapKey = null;
        if (!atlas.m_41619_()) {
            IMapCollection maps = MapAtlasItem.getMaps2(atlas, player.f_19853_);
            maps.fixDuplicates(player.f_19853_);
            Slice slice = MapAtlasItem.getSelectedSlice2(atlas, (ResourceKey<Level>)player.f_19853_.m_46472_());
            currentActiveMapKey = MapKey.at(maps.getScale(), player, slice);
            MapDataHolder select = maps.select(currentActiveMapKey);
            if (select == null) {
                select = maps.getClosest(player, slice);
            }
            if (select != null) {
                currentActiveMapKey = select.makeKey();
                currentActiveMap = select;
            }
        }
    }

    public static ItemStack getCurrentActiveAtlas() {
        return currentActiveAtlas;
    }

    public static MapKey getActiveMapKey() {
        return currentActiveMapKey;
    }

    public static MapDataHolder getActiveMap() {
        return currentActiveMap;
    }

    public static void setIsDrawingAtlas(boolean state) {
        isDrawingAtlas = state;
    }

    public static boolean isDrawingAtlas() {
        return isDrawingAtlas;
    }

    public static void init() {
        ClientPlatformHelper.addKeyBindRegistration(MapAtlasesClient::registerKeyBinding);
        ClientPlatformHelper.addClientSetup(MapAtlasesClient::clientSetup);
    }

    public static void clientSetup() {
        ItemProperties.register((Item)MapAtlasesMod.MAP_ATLAS.get(), (ResourceLocation)MapAtlasesMod.res("atlas"), MapAtlasesClient::getPredicateForAtlas);
    }

    public static void registerKeyBinding(ClientPlatformHelper.KeyBindEvent event) {
        event.register(OPEN_ATLAS_KEYBIND);
        event.register(DECREASE_MINIMAP_ZOOM);
        event.register(INCREASE_MINIMAP_ZOOM);
        if (MapAtlasesMod.TWILIGHTFOREST || MapAtlasesMod.SUPPLEMENTARIES) {
            event.register(INCREASE_SLICE);
            event.register(DECREASE_SLICE);
        }
    }

    @Deprecated(forRemoval=true)
    public static float getWorldMapZoomLevel() {
        return globalDecorationScale.get().floatValue();
    }

    public static void setDecorationsScale(float i) {
        globalDecorationScale.set(Float.valueOf(i));
    }

    public static void setDecorationRotation(float i) {
        globalDecorationRotation.set(Float.valueOf(i));
    }

    public static float getPredicateForAtlas(ItemStack stack, ClientLevel world, LivingEntity entity, int seed) {
        if (world == null && entity != null) {
            world = (ClientLevel)entity.f_19853_;
        }
        if (world == null) {
            return 0.0f;
        }
        boolean unlocked = !MapAtlasItem.isLocked(stack);
        ResourceKey dimension = world.m_46472_();
        int i = DIMENSION_TEXTURE_ORDER.indexOf(dimension.m_135782_().toString());
        if (i == -1) {
            return unlocked ? 0.96f : 1.0f;
        }
        return (float)i / 10.0f + (unlocked ? 0.0f : 0.05f);
    }

    public static void handleMapPacketWrapperPacket(S2CMapPacketWrapper packet) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Minecraft.m_91087_().f_91074_.f_108617_.m_7633_(packet.packet);
        MapItemSavedData data = level.m_7489_(MapItem.m_42848_((int)packet.packet.m_132445_()));
        if (data instanceof MapItemSavedDataAccessor) {
            MapItemSavedDataAccessor d = (MapItemSavedDataAccessor)data;
            try {
                d.setCenterX(packet.centerX);
                d.setCenterZ(packet.centerZ);
                d.setDimension((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)packet.dimension));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void openScreen(@Nullable BlockPos lecternPos, boolean pinOnly) {
        @Nullable LecternBlockEntity lectern = null;
        ItemStack atlas = ItemStack.f_41583_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (lecternPos == null) {
            atlas = MapAtlasesAccessUtils.getAtlasFromPlayerByConfig((Player)player);
        } else {
            BlockEntity blockEntity = player.f_19853_.m_7702_(lecternPos);
            if (blockEntity instanceof LecternBlockEntity) {
                LecternBlockEntity lec;
                lectern = lec = (LecternBlockEntity)blockEntity;
                atlas = lec.m_59566_();
            }
        }
        if (atlas.m_41720_() instanceof MapAtlasItem) {
            MapAtlasesClient.openScreen(atlas, lectern, pinOnly);
        }
    }

    public static void openScreen(ItemStack atlas, @Nullable LecternBlockEntity lectern, boolean pinOnly) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        IMapCollection maps = MapAtlasItem.getMaps2(atlas, (Level)level);
        maps.fixDuplicates((Level)level);
        if (!maps.isEmpty()) {
            Minecraft.m_91087_().m_91152_((Screen)new AtlasOverviewScreen(atlas, lectern, pinOnly));
        }
    }

    public static ContainerLevelAccess getClientAccess() {
        return ContainerLevelAccess.m_39289_((Level)Minecraft.m_91087_().f_91073_, (BlockPos)BlockPos.f_121853_);
    }

    public static void modifyTextDecorationTransform(PoseStack poseStack, float textWidth, float textScale) {
        Float scale = globalDecorationScale.get();
        if (scale != null) {
            scale = Float.valueOf(scale.floatValue() * (float)MapAtlasesClientConfig.markersTextScale.get().doubleValue());
            float s = textWidth * textScale / 2.0f;
            poseStack.m_85837_((double)s, -4.0, 0.0);
            Float rot = globalDecorationRotation.get();
            if (rot != null) {
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(rot.floatValue()));
            }
            poseStack.m_85837_((double)(-s * scale.floatValue()), (double)(4.0f * scale.floatValue()), 0.0);
            poseStack.m_85841_(scale.floatValue(), scale.floatValue(), 1.0f);
        }
    }

    public static void modifyDecorationTransform(PoseStack poseStack) {
        Float scale;
        Float rot = globalDecorationRotation.get();
        if (rot != null) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(rot.floatValue()));
        }
        if ((scale = globalDecorationScale.get()) != null) {
            scale = Float.valueOf(scale.floatValue() * (float)MapAtlasesClientConfig.markersScale.get().doubleValue());
            poseStack.m_85841_(scale.floatValue(), scale.floatValue(), 1.0f);
        }
    }

    public static void debugMapUpdated(String mapId) {
        CACHE.put((Object)mapId, (Object)10);
    }

    public static int debugIsMapUpdated(int light, String stringId) {
        Integer value = MapAtlasesClient.getValue(stringId);
        if (value != null) {
            int pBlockLight = Mth.m_14045_((int)((int)((float)value.intValue() / 10.0f * 15.0f)), (int)0, (int)15);
            return LightTexture.m_109885_((int)pBlockLight, (int)pBlockLight);
        }
        return light;
    }

    private static Integer getValue(String key) {
        Integer value = (Integer)CACHE.getIfPresent((Object)key);
        if (value != null) {
            Integer n = value;
            value = value - 1;
            if (value <= 0) {
                CACHE.invalidate((Object)key);
            } else {
                CACHE.put((Object)key, (Object)value);
            }
        }
        return value;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void decreaseHoodZoom() {
        MapAtlasesClientImpl.decreaseHoodZoom();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void increaseHoodZoom() {
        MapAtlasesClientImpl.increaseHoodZoom();
    }
}

