/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import pepjebs.mapatlases.client.screen.AtlasOverviewScreen;
import pepjebs.mapatlases.client.screen.BookmarkButton;
import pepjebs.mapatlases.integration.moonlight.CustomDecorationButton;
import pepjebs.mapatlases.networking.C2SRemoveMarkerPacket;
import pepjebs.mapatlases.networking.MapAtlasesNetworking;
import pepjebs.mapatlases.utils.DecorationHolder;
import pepjebs.mapatlases.utils.MapDataHolder;

public abstract class DecorationBookmarkButton
extends BookmarkButton {
    public static final ResourceLocation MAP_ICON_TEXTURE = new ResourceLocation("textures/map/map_icons.png");
    private static final int BUTTON_H = 14;
    private static final int BUTTON_W = 24;
    protected final MapDataHolder mapData;
    protected final String decorationId;
    protected int index = 0;
    protected boolean shfting = false;
    protected boolean control = false;

    protected DecorationBookmarkButton(int pX, int pY, AtlasOverviewScreen parentScreen, MapDataHolder data, String id) {
        super(pX - 24, pY, 24, 14, 0, 203, parentScreen);
        this.mapData = data;
        this.decorationId = id;
        this.shfting = Screen.m_96638_();
        this.control = Screen.m_96638_();
    }

    public static DecorationBookmarkButton of(int px, int py, DecorationHolder holder, AtlasOverviewScreen screen) {
        Object object = holder.deco();
        if (object instanceof MapDecoration) {
            MapDecoration md = (MapDecoration)object;
            return new Vanilla(px, py, screen, holder.data(), md, holder.id());
        }
        return CustomDecorationButton.create(px, py, screen, holder.data(), holder.deco(), holder.id());
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        this.shfting = Screen.m_96638_();
        this.control = Screen.m_96637_();
        this.tooltip = this.createTooltip();
        return false;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        this.shfting = Screen.m_96638_();
        this.control = Screen.m_96637_();
        this.tooltip = this.createTooltip();
        return false;
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.setSelected(true);
        if (this.shfting) {
            this.deleteMarker();
            this.parentScreen.recalculateDecorationWidgets();
        } else {
            this.parentScreen.centerOnDecoration(this);
        }
    }

    public void onClick(double mouseX, double mouseY, int button) {
        this.m_5716_(mouseX, mouseY);
    }

    protected abstract void deleteMarker();

    public abstract double getWorldX();

    public abstract double getWorldZ();

    public abstract Component getDecorationName();

    protected static double getDecorationPos(int decoX, MapItemSavedData data) {
        float s = (float)(1 << data.f_77890_) * 128.0f;
        return (double)s / 2.0 - (double)s / 2.0 * (double)((float)(decoX + 128) / 128.0f);
    }

    public int getBatchGroup() {
        return 0;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void m_6303_(PoseStack matrices, int pMouseX, int pMouseY, float pPartialTick) {
        matrices.m_85836_();
        matrices.m_85837_(0.0, 0.0, 0.01 * (double)this.index);
        super.m_6303_(matrices, pMouseX, pMouseY, pPartialTick);
        RenderSystem.m_157456_((int)0, (ResourceLocation)AtlasOverviewScreen.ATLAS_TEXTURE);
        if (this.control && this.canFocusMarker()) {
            this.m_93228_(matrices, this.f_93620_, this.f_93621_, 24, 173, 5, 5);
        } else if (this.shfting && this.canDeleteMarker()) {
            this.m_93228_(matrices, this.f_93620_, this.f_93621_, 24, 167, 5, 5);
        }
        this.renderDecoration(matrices, pMouseX, pMouseY);
        matrices.m_85849_();
        this.setSelected(false);
    }

    protected abstract void renderDecoration(PoseStack var1, int var2, int var3);

    @Override
    public List<Component> createTooltip() {
        if (this.control && this.canFocusMarker()) {
            return List.of(Component.m_237115_((String)"tooltip.map_atlases.focus_marker"));
        }
        if (this.shfting && this.canDeleteMarker()) {
            return List.of(Component.m_237115_((String)"tooltip.map_atlases.delete_marker"));
        }
        Component mapIconComponent = this.getDecorationName();
        MutableComponent coordsComponent = Component.m_237113_((String)("X: " + (int)this.getWorldX() + ", Z: " + (int)this.getWorldZ())).m_130940_(ChatFormatting.GRAY);
        Component t = mapIconComponent;
        MutableComponent t2 = coordsComponent;
        return List.of(t, t2);
    }

    protected boolean canFocusMarker() {
        return false;
    }

    protected boolean canDeleteMarker() {
        return true;
    }

    public static class Vanilla
    extends DecorationBookmarkButton {
        private final MapDecoration decoration;
        private final boolean isBanner;

        public Vanilla(int px, int py, AtlasOverviewScreen screen, MapDataHolder data, MapDecoration mapDecoration, String decoId) {
            super(px, py, screen, data, decoId);
            this.decoration = mapDecoration;
            this.tooltip = this.createTooltip();
            this.isBanner = this.decoration.m_77803_().name().startsWith("BANNER");
        }

        @Override
        protected boolean canDeleteMarker() {
            return this.isBanner;
        }

        @Override
        public double getWorldX() {
            return (double)this.mapData.data.f_77885_ - Vanilla.getDecorationPos(this.decoration.m_77804_(), this.mapData.data);
        }

        @Override
        public double getWorldZ() {
            return (double)this.mapData.data.f_77886_ - Vanilla.getDecorationPos(this.decoration.m_77805_(), this.mapData.data);
        }

        @Override
        public Component getDecorationName() {
            Component name = this.decoration.m_77810_();
            return name == null ? Component.m_237113_((String)AtlasOverviewScreen.getReadableName(this.decoration.m_77803_().name().toLowerCase(Locale.ROOT))) : name;
        }

        @Override
        protected void renderDecoration(PoseStack matrices, int pMouseX, int pMouseY) {
            byte b = this.decoration.m_77802_();
            int u = b % 16 * 8;
            int v = b / 16 * 8;
            matrices.m_85837_((double)((float)this.f_93620_ + (float)this.f_93618_ / 2.0f), (double)((float)this.f_93621_ + (float)this.f_93619_ / 2.0f), 0.001);
            matrices.m_85845_(Vector3f.f_122227_.m_122240_((float)(this.decoration.m_77806_() * 360) / 16.0f));
            matrices.m_85841_(-1.0f, -1.0f, 1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)MAP_ICON_TEXTURE);
            Vanilla.m_93133_((PoseStack)matrices, (int)-4, (int)-4, (float)u, (float)v, (int)8, (int)8, (int)128, (int)128);
        }

        @Override
        protected void deleteMarker() {
            Map decorations = this.mapData.data.f_77894_;
            MapDecoration d = (MapDecoration)decorations.get(this.decorationId);
            if (d != null) {
                MapAtlasesNetworking.CHANNEL.sendToServer((Message)new C2SRemoveMarkerPacket(this.mapData.stringId, d.hashCode(), false));
                decorations.remove(this.decorationId);
            }
        }
    }
}

