/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.integration.moonlight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.moonlight.api.map.MapHelper;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.utils.DecorationHolder;
import pepjebs.mapatlases.utils.MapDataHolder;

public class MoonlightCompat {
    public static void init() {
    }

    public static Collection<DecorationHolder> getCustomDecorations(MapDataHolder map) {
        return ((ExpandedMapData)map.data).getCustomDecorations().entrySet().stream().map(a -> new DecorationHolder(a.getValue(), (String)a.getKey(), map)).toList();
    }

    public static void addDecoration(MapItemSavedData data, BlockPos pos, ResourceLocation id, @Nullable Component name) {
        MapDecorationType type = MapDecorationRegistry.get((ResourceLocation)id);
        if (type != null) {
            MapBlockMarker defaultMarker = type.createEmptyMarker();
            defaultMarker.setPos(pos);
            defaultMarker.setName(name);
            ((ExpandedMapData)data).addCustomMarker(defaultMarker);
        }
    }

    public static void removeCustomDecoration(MapItemSavedData data, int hash) {
        if (data instanceof ExpandedMapData) {
            ExpandedMapData d = (ExpandedMapData)data;
            String selected = null;
            for (Map.Entry v : d.getCustomMarkers().entrySet()) {
                CustomMapDecoration decorationFromMarker = ((MapBlockMarker)v.getValue()).createDecorationFromMarker(data);
                if (decorationFromMarker == null || decorationFromMarker.hashCode() != hash) continue;
                selected = (String)v.getKey();
            }
            if (selected == null || !d.removeCustomMarker(selected)) {
                MapAtlasesMod.LOGGER.warn("Tried to delete custom marker but none was found");
            }
        }
    }

    public static boolean maybePlacePinInFront(Player player, ItemStack atlas) {
        HitResult hit = Utils.rayTrace((LivingEntity)player, (Level)player.f_19853_, (ClipContext.Block)ClipContext.Block.OUTLINE, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hit instanceof BlockHitResult) {
            BlockHitResult bi = (BlockHitResult)hit;
            if (hit.m_6662_() == HitResult.Type.BLOCK) {
                return MapHelper.toggleMarkersAtPos((Level)player.f_19853_, (BlockPos)bi.m_82425_(), (ItemStack)atlas, (Player)player);
            }
        }
        return false;
    }

    public static void updateMarkers(MapItemSavedData data, Player player, int maxRange) {
        ExpandedMapData d = (ExpandedMapData)data;
        HashMap markers = new HashMap(d.getCustomMarkers());
        if (!markers.isEmpty()) {
            markers.entrySet().removeIf(m -> !((MapBlockMarker)m.getValue()).shouldRefresh());
            ArrayList<String> toRemove = new ArrayList<String>();
            ArrayList<MapBlockMarker> toAdd = new ArrayList<MapBlockMarker>();
            Level level = player.f_19853_;
            for (Map.Entry m2 : markers.entrySet()) {
                MapBlockMarker marker = (MapBlockMarker)m2.getValue();
                BlockPos pos = marker.getPos();
                if (!(pos.m_203193_((Position)player.m_20182_()) < (double)(maxRange * maxRange)) || !level.m_46749_(pos)) continue;
                MapBlockMarker newMarker = marker.getType().getWorldMarkerFromWorld((BlockGetter)level, marker.getPos());
                String id = (String)m2.getKey();
                if (newMarker == null) {
                    toRemove.add(id);
                    continue;
                }
                if (Objects.equals(marker, newMarker)) continue;
                toRemove.add(id);
                toAdd.add(newMarker);
            }
            toRemove.forEach(arg_0 -> ((ExpandedMapData)d).removeCustomMarker(arg_0));
            toAdd.forEach(arg_0 -> ((ExpandedMapData)d).addCustomMarker(arg_0));
        }
    }
}

