/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.mixin;

import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CartographyTableMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.PlatStuff;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.config.MapAtlasesConfig;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.map_collection.IMapCollection;
import pepjebs.mapatlases.utils.AtlasCartographyTable;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;
import pepjebs.mapatlases.utils.MapDataHolder;
import pepjebs.mapatlases.utils.Slice;

@Mixin(value={CartographyTableMenu.class})
public abstract class CartographyTableMenuMixin
extends AbstractContainerMenu
implements AtlasCartographyTable {
    @Shadow
    @Final
    private ResultContainer f_39138_;
    @Shadow
    @Final
    private ContainerLevelAccess f_39136_;
    @Shadow
    @Final
    public Container f_39135_;
    @Unique
    private int mapatlases$selectedMapIndex;
    @Unique
    @Nullable
    private Slice mapatlases$selectedSlice;

    @Shadow
    public abstract void m_6199_(Container var1);

    protected CartographyTableMenuMixin(@Nullable MenuType<?> arg, int i) {
        super(arg, i);
    }

    @Inject(method={"setupResultSlot"}, at={@At(value="HEAD")}, cancellable=true)
    void mapAtlasUpdateResult(ItemStack topItem, ItemStack bottomItem, ItemStack oldResult, CallbackInfo info) {
        if (!topItem.m_150930_((Item)MapAtlasesMod.MAP_ATLAS.get())) {
            return;
        }
        if (PlatStuff.isShear(bottomItem)) {
            this.f_39136_.m_39292_((world, blockPos) -> {
                IMapCollection maps = MapAtlasItem.getMaps2(topItem, world);
                if (maps.isEmpty()) {
                    return;
                }
                if (this.mapatlases$selectedMapIndex > maps.getCount()) {
                    this.mapatlases$selectedMapIndex = 0;
                }
                MapDataHolder map = maps.getAll().get(this.mapatlases$selectedMapIndex);
                ItemStack result = MapAtlasesAccessUtils.createMapItemStackFromId(map.id);
                this.mapatlases$selectedSlice = map.slice;
                this.f_39138_.m_6836_(2, result);
                this.m_38946_();
                info.cancel();
            });
        } else if (bottomItem.m_150930_((Item)MapAtlasesMod.MAP_ATLAS.get())) {
            this.f_39136_.m_39292_((world, blockPos) -> {
                int[] idsToADd;
                ItemStack result = topItem.m_41777_();
                IMapCollection resultMaps = MapAtlasItem.getMaps2(result, world);
                IMapCollection bottomMaps = MapAtlasItem.getMaps2(bottomItem, world);
                if (resultMaps.getScale() != bottomMaps.getScale()) {
                    return;
                }
                for (int i : idsToADd = bottomMaps.getAllIds()) {
                    resultMaps.add(i, (Level)world);
                }
                MapAtlasItem.setEmptyMaps(result, (int)Math.ceil((float)(MapAtlasItem.getEmptyMaps(result) + MapAtlasItem.getEmptyMaps(bottomItem)) / 2.0f));
                result.m_41769_(1);
                this.f_39138_.m_6836_(2, result);
                this.m_38946_();
                info.cancel();
            });
        } else if (bottomItem.m_41720_() == Items.f_42676_ || MapAtlasesConfig.acceptPaperForEmptyMaps.get().booleanValue() && bottomItem.m_41720_() == Items.f_42516_) {
            this.f_39136_.m_39292_((world, blockPos) -> {
                ItemStack result = topItem.m_41777_();
                int amountToAdd = MapAtlasesAccessUtils.getMapCountToAdd(topItem, bottomItem, world);
                MapAtlasItem.increaseEmptyMaps(result, amountToAdd);
                this.f_39138_.m_6836_(2, result);
                this.m_38946_();
                info.cancel();
            });
        } else if (bottomItem.m_41720_() == Items.f_42573_) {
            this.f_39136_.m_39292_((world, blockPos) -> {
                ItemStack result = topItem.m_41777_();
                Integer mapId = MapItem.m_151131_((ItemStack)bottomItem);
                IMapCollection maps = MapAtlasItem.getMaps2(result, world);
                if (mapId != null && maps.add(mapId, (Level)world)) {
                    this.f_39138_.m_6836_(2, result);
                    this.m_38946_();
                    info.cancel();
                }
            });
        }
    }

    @Inject(method={"quickMoveStack"}, at={@At(value="HEAD")}, cancellable=true)
    void mapAtlasTransferSlot(Player player, int index, CallbackInfoReturnable<ItemStack> info) {
        if (index >= 0 && index <= 2) {
            return;
        }
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            if (PlatStuff.isShear(stack) && !this.m_38903_(stack, 1, 1, false)) {
                info.setReturnValue((Object)ItemStack.f_41583_);
                return;
            }
            if (stack.m_41720_() != MapAtlasesMod.MAP_ATLAS.get()) {
                return;
            }
            boolean result = this.m_38903_(stack, 0, 2, false);
            if (!result) {
                info.setReturnValue((Object)ItemStack.f_41583_);
            }
        }
    }

    @Override
    public void mapatlases$setSelectedMapIndex(int index) {
        this.mapatlases$selectedMapIndex = index;
    }

    @Override
    public int mapatlases$getSelectedMapIndex() {
        return this.mapatlases$selectedMapIndex;
    }

    @Override
    @Nullable
    public Slice mapatlases$getSelectedSlice() {
        return this.mapatlases$selectedSlice;
    }

    @Override
    public void mapatlases$removeSelectedMap(ItemStack atlas) {
        this.f_39136_.m_39292_((level, pos) -> {
            IMapCollection maps = MapAtlasItem.getMaps2(atlas, level);
            MapDataHolder m = maps.getAll().get(this.mapatlases$selectedMapIndex);
            maps.remove(m);
        });
    }

    public boolean m_6366_(Player pPlayer, int pId) {
        ItemStack atlas = ((Slot)this.f_38839_.get(0)).m_7993_();
        if (pId == 4 || pId == 5) {
            AtomicReference l = new AtomicReference();
            this.f_39136_.m_39292_((level, pos) -> l.set(level));
            if (l.get() == null) {
                try {
                    MapAtlasesClient.getClientAccess().m_39292_((level, pos) -> l.set(level));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (l.get() != null && atlas.m_41720_() == MapAtlasesMod.MAP_ATLAS.get()) {
                IMapCollection maps = MapAtlasItem.getMaps2(atlas, (Level)l.get());
                this.mapatlases$selectedMapIndex = (this.mapatlases$selectedMapIndex + (pId == 4 ? maps.getCount() - 1 : 1)) % maps.getCount();
                try {
                    MapDataHolder map = maps.getAll().get(this.mapatlases$selectedMapIndex);
                    this.mapatlases$selectedSlice = map != null ? map.slice : null;
                }
                catch (Exception e) {
                    boolean bl = true;
                }
            }
            this.m_6199_(this.f_39135_);
            return true;
        }
        return super.m_6366_(pPlayer, pId);
    }
}

