/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.networking;

import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.maps.MapBanner;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.integration.moonlight.MoonlightCompat;

public class C2SRemoveMarkerPacket
implements Message {
    private final int decoHash;
    private final String mapId;
    private final boolean isCustom;

    public C2SRemoveMarkerPacket(FriendlyByteBuf buf) {
        this.mapId = buf.m_130277_();
        this.decoHash = buf.m_130242_();
        this.isCustom = buf.readBoolean();
    }

    public C2SRemoveMarkerPacket(String map, int decoId, boolean custom) {
        this.decoHash = decoId;
        this.mapId = map;
        this.isCustom = custom;
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.m_130070_(this.mapId);
        buf.m_130130_(this.decoHash);
        buf.writeBoolean(this.isCustom);
    }

    public void handle(ChannelHandler.Context context) {
        Player player = context.getSender();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Level level = player2.f_19853_;
        MapItemSavedData data = level.m_7489_(this.mapId);
        if (data != null) {
            if (!this.isCustom) {
                if (!C2SRemoveMarkerPacket.removeBannerMarker(data, level, this.decoHash)) {
                    MapAtlasesMod.LOGGER.warn("Tried to delete banner marker but none was found");
                }
            } else if (MapAtlasesMod.MOONLIGHT) {
                MoonlightCompat.removeCustomDecoration(data, this.decoHash);
            }
        }
    }

    public static boolean removeBannerMarker(MapItemSavedData data, Level level, int hash) {
        for (MapBanner mapBanner : data.m_164809_()) {
            MapDecoration mapDecoration;
            byte d;
            MapDecoration.Type type = mapBanner.m_77782_();
            float rotation = 180.0f;
            int i = 1 << data.f_77890_;
            float f = (float)((double)mapBanner.m_77773_().m_123341_() - (double)data.f_77885_) / (float)i;
            float g = (float)((double)mapBanner.m_77773_().m_123343_() - (double)data.f_77886_) / (float)i;
            int b = (int)((double)(f * 2.0f) + 0.5);
            int c = (int)((double)(g * 2.0f) + 0.5);
            if (f >= -63.0f && g >= -63.0f && f <= 63.0f && g <= 63.0f) {
                rotation = (float)((double)rotation + 8.0);
                d = (byte)((double)rotation * 16.0 / 360.0);
                if (data.f_77887_ == Level.f_46429_ && level != null) {
                    int k = (int)(level.m_6106_().m_6792_() / 10L);
                    d = (byte)(k * k * 34187121 + k * 121 >> 15 & 0xF);
                }
            } else {
                d = 0;
                if (f <= -63.0f) {
                    b = -128;
                }
                if (g <= -63.0f) {
                    c = -128;
                }
                if (f >= 63.0f) {
                    b = 127;
                }
                if (g >= 63.0f) {
                    c = 127;
                }
            }
            if ((mapDecoration = new MapDecoration(type, (byte)(b + 1), (byte)(c + 1), d, mapBanner.m_77783_())).hashCode() != hash) continue;
            data.m_77934_((LevelAccessor)level, mapBanner.m_77773_());
            return true;
        }
        return false;
    }
}

