/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.networking;

import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;
import pepjebs.mapatlases.utils.MapType;
import pepjebs.mapatlases.utils.Slice;

public class C2SSelectSlicePacket
implements Message {
    @Nullable
    private final BlockPos lecternPos;
    private final Slice slice;

    public C2SSelectSlicePacket(Slice slice, @Nullable BlockPos lecternPos) {
        this.slice = slice;
        this.lecternPos = lecternPos;
    }

    public C2SSelectSlicePacket(FriendlyByteBuf buf) {
        ResourceKey dimension = buf.m_236801_(Registry.f_122819_);
        MapType type = MapType.values()[buf.m_130242_()];
        Integer h = buf.readBoolean() ? null : Integer.valueOf(buf.m_130242_());
        this.slice = Slice.of(type, h, (ResourceKey<Level>)dimension);
        this.lecternPos = buf.readBoolean() ? null : buf.m_130135_();
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.m_236858_(this.slice.dimension());
        buf.m_130130_(this.slice.type().ordinal());
        Integer h = this.slice.height();
        buf.writeBoolean(h == null);
        if (h != null) {
            buf.m_130130_(h.intValue());
        }
        buf.writeBoolean(this.lecternPos == null);
        if (this.lecternPos != null) {
            buf.m_130064_(this.lecternPos);
        }
    }

    public void handle(ChannelHandler.Context context) {
        Player player = context.getSender();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ItemStack atlas = MapAtlasesAccessUtils.getAtlasFromPlayerByConfig((Player)player2);
        if (!atlas.m_41619_()) {
            MapAtlasItem.setSelectedSlice(atlas, this.slice);
        }
    }
}

