/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.recipe;

import java.lang.ref.WeakReference;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.integration.SupplementariesCompat;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.map_collection.IMapCollection;
import pepjebs.mapatlases.utils.MapDataHolder;

public class AntiqueAtlasRecipe
extends CustomRecipe {
    private WeakReference<Level> levelRef = new WeakReference<Object>(null);

    public AntiqueAtlasRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        if (!MapAtlasesMod.SUPPLEMENTARIES) {
            return false;
        }
        ItemStack atlas = ItemStack.f_41583_;
        ItemStack ink = ItemStack.f_41583_;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_150930_((Item)MapAtlasesMod.MAP_ATLAS.get())) {
                if (!atlas.m_41619_()) {
                    return false;
                }
                if (SupplementariesCompat.hasAntiqueInk(itemstack)) {
                    return false;
                }
                atlas = itemstack;
                continue;
            }
            if (SupplementariesCompat.isAntiqueInk(itemstack)) {
                if (!ink.m_41619_()) {
                    return false;
                }
                ink = itemstack;
                continue;
            }
            if (itemstack.m_41619_()) continue;
            return false;
        }
        if (!atlas.m_41619_() && !ink.m_41619_()) {
            this.levelRef = new WeakReference<Level>(level);
            return true;
        }
        return false;
    }

    public ItemStack assemble(CraftingContainer inv) {
        Level level = (Level)this.levelRef.get();
        ItemStack newAtlas = ItemStack.f_41583_;
        ItemStack oldAtlas = ItemStack.f_41583_;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (!itemstack.m_150930_((Item)MapAtlasesMod.MAP_ATLAS.get())) continue;
            newAtlas = itemstack.m_41777_();
            newAtlas.m_41764_(1);
            oldAtlas = itemstack;
        }
        IMapCollection maps = MapAtlasItem.getMaps2(newAtlas, level);
        IMapCollection oldMaps = MapAtlasItem.getMaps2(oldAtlas, level);
        for (MapDataHolder holder : maps.getAll()) {
            oldMaps.remove(holder);
            Integer newId = SupplementariesCompat.createAntiqueMapData(holder, level, true, false);
            if (newId == null) continue;
            oldMaps.add(newId, level);
        }
        SupplementariesCompat.setAntiqueInk(newAtlas);
        return newAtlas;
    }

    public RecipeSerializer<?> m_7707_() {
        return MapAtlasesMod.MAP_ANTIQUE_RECIPE.get();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }
}

