/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.recipe;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.config.MapAtlasesConfig;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.map_collection.IMapCollection;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;
import pepjebs.mapatlases.utils.MapDataHolder;

public class MapAtlasesAddRecipe
extends CustomRecipe {
    private WeakReference<Level> levelRef = new WeakReference<Object>(null);

    public MapAtlasesAddRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        ItemStack atlas = ItemStack.f_41583_;
        int emptyMaps = 0;
        ArrayList<MapDataHolder> filledMaps = new ArrayList<MapDataHolder>();
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_150930_((Item)MapAtlasesMod.MAP_ATLAS.get())) {
                if (!atlas.m_41619_()) {
                    return false;
                }
                atlas = itemstack;
                continue;
            }
            if (this.isEmptyMap(itemstack)) {
                ++emptyMaps;
                continue;
            }
            if (MapAtlasesAccessUtils.isValidFilledMap(itemstack)) {
                filledMaps.add(MapAtlasesAccessUtils.findMapFromItemStack(level, itemstack));
                continue;
            }
            if (itemstack.m_41619_()) continue;
            return false;
        }
        if (!(atlas.m_41619_() || emptyMaps == 0 && filledMaps.isEmpty())) {
            int extraMaps = emptyMaps + filledMaps.size();
            IMapCollection maps = MapAtlasItem.getMaps2(atlas, level);
            int mapCount = maps.getCount() + MapAtlasItem.getEmptyMaps(atlas);
            if (MapAtlasItem.getMaxMapCount() != -1 && mapCount + extraMaps - 1 > MapAtlasItem.getMaxMapCount()) {
                return false;
            }
            byte atlasScale = maps.getScale();
            for (MapDataHolder d : filledMaps) {
                if (d.data.f_77890_ != atlasScale) {
                    return false;
                }
                if (maps.select(d.makeKey()) == null) continue;
                return false;
            }
            this.levelRef = new WeakReference<Level>(level);
            return true;
        }
        return false;
    }

    private boolean isEmptyMap(ItemStack itemstack) {
        if (itemstack.m_41619_()) {
            return false;
        }
        if (MapAtlasesAccessUtils.isValidEmptyMap(itemstack)) {
            return MapAtlasesConfig.enableEmptyMapEntryAndFill.get();
        }
        if (itemstack.m_150930_(Items.f_42516_)) {
            return MapAtlasesConfig.acceptPaperForEmptyMaps.get();
        }
        return false;
    }

    public ItemStack assemble(CraftingContainer inv) {
        Level level = (Level)this.levelRef.get();
        ItemStack atlas = ItemStack.f_41583_;
        int emptyMapCount = 0;
        ArrayList<Integer> mapIds = new ArrayList<Integer>();
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack itemstack = inv.m_8020_(j);
            if (itemstack.m_150930_((Item)MapAtlasesMod.MAP_ATLAS.get())) {
                atlas = itemstack.m_41777_();
                atlas.m_41764_(1);
                continue;
            }
            if (this.isEmptyMap(itemstack)) {
                ++emptyMapCount;
                continue;
            }
            if (!MapAtlasesAccessUtils.isValidFilledMap(itemstack)) continue;
            mapIds.add(MapItem.m_151131_((ItemStack)itemstack));
        }
        emptyMapCount *= MapAtlasesConfig.mapEntryValueMultiplier.get().intValue();
        IMapCollection maps = MapAtlasItem.getMaps2(atlas, level);
        for (Integer i : mapIds) {
            maps.add(i, level);
        }
        MapAtlasItem.increaseEmptyMaps(atlas, emptyMapCount);
        return atlas;
    }

    public RecipeSerializer<?> m_7707_() {
        return MapAtlasesMod.MAP_ATLAS_ADD_RECIPE.get();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }
}

