/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.recipe;

import java.lang.ref.WeakReference;
import java.util.Optional;
import java.util.TreeSet;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.config.MapAtlasesConfig;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.map_collection.IMapCollection;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;
import pepjebs.mapatlases.utils.MapDataHolder;
import pepjebs.mapatlases.utils.Slice;

public class MapAtlasesCutExistingRecipe
extends CustomRecipe {
    private WeakReference<Level> levelRef = new WeakReference<Object>(null);

    public MapAtlasesCutExistingRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer inv, Level level) {
        boolean b;
        ItemStack atlas = ItemStack.f_41583_;
        ItemStack shears = ItemStack.f_41583_;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack i = inv.m_8020_(j);
            if (i.m_41619_()) continue;
            if (i.m_150930_((Item)MapAtlasesMod.MAP_ATLAS.get()) && (MapAtlasItem.getEmptyMaps(i) > 0 || MapAtlasItem.getMaps2(i, level).getCount() > 0)) {
                if (!atlas.m_41619_()) {
                    return false;
                }
                atlas = i;
                continue;
            }
            if (i.m_150930_(Items.f_42574_) && i.m_41773_() < i.m_41776_() - 1) {
                if (!shears.m_41619_()) {
                    return false;
                }
                shears = i;
                continue;
            }
            return false;
        }
        boolean bl = b = !shears.m_41619_() && !atlas.m_41619_();
        if (b) {
            this.levelRef = new WeakReference<Level>(level);
        }
        return b;
    }

    public ItemStack assemble(CraftingContainer inv) {
        IMapCollection maps;
        ItemStack atlas = ItemStack.f_41583_;
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack i = inv.m_8020_(j);
            if (!i.m_150930_((Item)MapAtlasesMod.MAP_ATLAS.get())) continue;
            atlas = i;
            break;
        }
        if ((maps = MapAtlasItem.getMaps2(atlas, (Level)this.levelRef.get())).getCount() > 1) {
            Slice slice = MapAtlasItem.getSelectedSlice2(atlas, (ResourceKey<Level>)((Level)this.levelRef.get()).m_46472_());
            MapDataHolder toRemove = MapAtlasesCutExistingRecipe.getMapToRemove(inv, maps, slice);
            return MapAtlasesAccessUtils.createMapItemStackFromId(toRemove.id);
        }
        if (MapAtlasItem.getEmptyMaps(atlas) > 0) {
            return new ItemStack((ItemLike)Items.f_42676_);
        }
        return ItemStack.f_41583_;
    }

    private static MapDataHolder getMapToRemove(CraftingContainer tc, IMapCollection maps, Slice slice) {
        try {
            AbstractContainerMenu abstractContainerMenu = tc.f_39323_;
            if (abstractContainerMenu instanceof CraftingMenu) {
                CraftingMenu cm = (CraftingMenu)abstractContainerMenu;
                c = maps.getClosest(cm.f_39351_, slice);
                if (c != null) {
                    return c;
                }
            } else {
                c = tc.f_39323_;
                if (c instanceof InventoryMenu) {
                    InventoryMenu im = (InventoryMenu)c;
                    c = maps.getClosest(im.f_39703_, slice);
                    if (c != null) {
                        return c;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (MapDataHolder)maps.getAll().stream().findAny().get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList list = NonNullList.m_122779_();
        for (int j = 0; j < inv.m_6643_(); ++j) {
            ItemStack i = inv.m_8020_(j);
            ItemStack stack = i.m_41777_();
            if (stack.m_41720_() == Items.f_42574_) {
                stack.m_220157_(1, RandomSource.m_216327_(), null);
            } else if (stack.m_150930_((Item)MapAtlasesMod.MAP_ATLAS.get())) {
                int emptyMaps;
                boolean didRemoveFilled = false;
                IMapCollection maps = MapAtlasItem.getMaps2(stack, (Level)this.levelRef.get());
                if (!maps.isEmpty()) {
                    Optional first;
                    Slice slice = MapAtlasItem.getSelectedSlice2(stack, (ResourceKey<Level>)((Level)this.levelRef.get()).m_46472_());
                    maps.remove(MapAtlasesCutExistingRecipe.getMapToRemove(inv, maps, slice));
                    TreeSet<Integer> tree = maps.getHeightTree(slice.dimension(), slice.type());
                    if (!tree.contains(slice.heightOrTop()) && (first = tree.stream().findFirst()).isPresent()) {
                        Integer newH = (Integer)first.get();
                        MapAtlasItem.setSelectedSlice(stack, Slice.of(slice.type(), newH, slice.dimension()));
                    }
                    didRemoveFilled = true;
                }
                if ((emptyMaps = MapAtlasItem.getEmptyMaps(stack)) > 0 && !didRemoveFilled) {
                    int multiplier = MapAtlasesConfig.mapEntryValueMultiplier.get();
                    int amountToSet = Math.max(emptyMaps - multiplier, 0);
                    MapAtlasItem.setEmptyMaps(stack, amountToSet);
                }
            }
            list.add((Object)stack);
        }
        return list;
    }

    public boolean m_8004_(int width, int height) {
        return width + height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return MapAtlasesMod.MAP_ATLAS_CUT_RECIPE.get();
    }
}

