/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.utils;

import com.mojang.datafixers.util.Pair;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapBanner;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.capabilities.MapKey;
import pepjebs.mapatlases.config.MapAtlasesConfig;
import pepjebs.mapatlases.integration.moonlight.MoonlightCompat;
import pepjebs.mapatlases.mixin.MapItemSavedDataAccessor;
import pepjebs.mapatlases.networking.MapAtlasesNetworking;
import pepjebs.mapatlases.networking.S2CDebugUpdateMapPacket;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;
import pepjebs.mapatlases.utils.MapType;
import pepjebs.mapatlases.utils.Slice;

public class MapDataHolder {
    public final int id;
    public final String stringId;
    public final MapItemSavedData data;
    public final Slice slice;
    public final MapType type;
    @Nullable
    public final Integer height;
    private static final ExecutorService EXECUTORS = Executors.newFixedThreadPool(6);

    public MapDataHolder(String name, MapItemSavedData data) {
        this(MapAtlasesAccessUtils.findMapIntFromString(name), name, data);
    }

    private MapDataHolder(int id, String stringId, MapItemSavedData data) {
        this.id = id;
        this.stringId = stringId;
        this.data = data;
        this.type = MapType.fromKey(stringId, data);
        this.height = this.type.getHeight(data);
        this.slice = Slice.of(this.type, this.height, (ResourceKey<Level>)data.f_77887_);
    }

    @Nullable
    public static MapDataHolder findFromId(Level level, int id) {
        for (MapType t : MapType.values()) {
            Pair<String, MapItemSavedData> d = t.getMapData(level, id);
            if (d == null) continue;
            return new MapDataHolder(id, (String)d.getFirst(), (MapItemSavedData)d.getSecond());
        }
        return null;
    }

    public MapKey makeKey() {
        return MapKey.at(this.data.f_77890_, this.data.f_77885_, this.data.f_77886_, this.slice);
    }

    public void updateMap(ServerPlayer player) {
        if (MapDataHolder.canMultiThread(player.f_19853_)) {
            EXECUTORS.submit(() -> ((MapItem)this.type.filled).m_42893_(player.f_19853_, (Entity)player, this.data));
            this.updateMarkers((Player)player, 128);
        } else {
            ((MapItem)this.type.filled).m_42893_(player.f_19853_, (Entity)player, this.data);
        }
        if (MapAtlasesConfig.debugUpdate.get().booleanValue()) {
            MapAtlasesNetworking.CHANNEL.sendToClientPlayer(player, (Message)new S2CDebugUpdateMapPacket(this.stringId));
        }
    }

    private static boolean canMultiThread(Level level) {
        MapAtlasesConfig.UpdateType updateType = MapAtlasesConfig.mapUpdateMultithreaded.get();
        return switch (updateType) {
            default -> throw new IncompatibleClassChangeError();
            case MapAtlasesConfig.UpdateType.OFF -> false;
            case MapAtlasesConfig.UpdateType.ALWAYS_ON -> true;
            case MapAtlasesConfig.UpdateType.SINGLE_PLAYER_ONLY -> !level.m_7654_().m_6992_();
        };
    }

    private void updateMarkers(Player player, int maxRange) {
        int step = this.data.m_77916_((Player)player).f_77960_;
        int frenquency = MapAtlasesConfig.markersUpdatePeriod.get();
        if (step % frenquency == 0) {
            MapItemSavedDataAccessor accessor = (MapItemSavedDataAccessor)this.data;
            Map<String, MapBanner> markers = accessor.getBannerMarkers();
            Iterator<MapBanner> iterator = markers.values().iterator();
            Level level = player.f_19853_;
            while (iterator.hasNext()) {
                MapBanner mapbanner1;
                MapBanner banner = iterator.next();
                BlockPos pos = banner.m_77773_();
                if (!(pos.m_203193_((Position)player.m_20182_()) < (double)(maxRange * maxRange)) || !level.m_46749_(pos) || banner.equals((Object)(mapbanner1 = MapBanner.m_77774_((BlockGetter)level, (BlockPos)pos)))) continue;
                iterator.remove();
                accessor.invokeRemoveDecoration(banner.m_77787_());
            }
            if (MapAtlasesMod.MOONLIGHT) {
                MoonlightCompat.updateMarkers(this.data, player, maxRange);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapDataHolder holder = (MapDataHolder)o;
        return Objects.equals(this.data, holder.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }
}

